<?php
// Förhindra att sidan renderas flera gånger
global $bokforehandel_runs_page_rendered;
if (isset($bokforehandel_runs_page_rendered) && $bokforehandel_runs_page_rendered === true) {
    return;
}
$bokforehandel_runs_page_rendered = true;

// Säkerställ att vi har användar-ID för Bjorn Lunden
$user_id = get_option('bokforehandel_user_id', '');
?>
<div class="wrap bokforehandel-admin">
    <h1 class="wp-heading-inline">Bokför Ehandel - Synkroniseringar</h1>
    
    <?php if ($user_id): ?>
    <div class="bokforehandel-admin-content">
        <div class="bokforehandel-tabs-content">
            <div class="bokforehandel-tab" style="display: block;">
                <div class="bokforehandel-runs-container">
                    <div class="bokforehandel-runs-list bokforehandel-card">
                        <h2>Synkroniseringshistorik</h2>
                        <p class="bokforehandel-section-description">Här visas de 20 senaste synkroniseringar som har körts samt deras status.</p>
                        <table class="bokforehandel-runs-table widefat striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Datum</th>
                                    <th>Operation</th>
                                    <th>Status</th>
                                    <th>Antal</th>
                                    <th>Tid</th>
                                    <th>Åtgärder</th>
                                </tr>
                            </thead>
                            <tbody id="runs-table-body">
                                <tr>
                                    <td colspan="7">Laddar synkroniseringshistorik...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="bokforehandel-run-details bokforehandel-card" style="display: none;">
                        <h2>Synkroniseringsdetaljer</h2>
                        <div id="run-details-content" class="bokforehandel-welcome-panel">
                            <p>Välj en körning för att se detaljer.</p>
                        </div>
                        <div class="submit form-buttons">
                            <button id="back-to-runs" class="button button-secondary button-large">Tillbaka till listan</button>
                        </div>
                    </div>
                </div>
                
                <!-- Retroaktiv synkning -->
                <div class="bokforehandel-welcome-panel bokforehandel-retro-sync-box" style="margin-top: 40px;">
                    <h2>Bokför ordrar manuellt</h2>
                    <p class="description">Bokför äldre orders och/eller utbetalningar. Har du just installerat pluginet så synkronisera fram till igår och låt autosynken ta över från dagens ordrar.</p>
                    
                    <form id="retro-sync-form" class="bokforehandel-form">
                        <div class="form-fields" style="display: flex; flex-wrap: wrap; gap: 20px; align-items: flex-end; margin-top: 20px;">
                            <div class="form-field">
                                <label for="sync-operation">Vad vill du bokföra?</label>
                                <select id="sync-operation" name="operation">
                                    <option value="all">Ordrar + utbetalningar</option>
                                    <option value="woo">WooCommerce-ordrar</option>
                                    <option value="klarna">Klarna-utbetalningar</option>
                                    <option value="stripe">Stripe-utbetalningar</option>
                                </select>
                            </div>
                            
                            <div class="form-field">
                                <label for="sync-start-date">Startdatum (ÅÅÅÅMMDD tex 20250101)</label>
                                <input type="text" id="sync-start-date" name="start_date" placeholder="ÅÅÅÅMMDD" pattern="[0-9]{8}" maxlength="8">
                            </div>
                            
                            <div class="form-field">
                                <label for="sync-end-date">Slutdatum (ÅÅÅÅMMDD tex 20250131)</label>
                                <input type="text" id="sync-end-date" name="end_date" placeholder="ÅÅÅÅMMDD" pattern="[0-9]{8}" maxlength="8">
                            </div>
                            
                            <div class="form-field">
                                <button type="submit" id="run-sync-button" class="button button-primary">Bokför ordrar manuellt</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<script type="text/javascript">
    jQuery(document).ready(function($) {
        // Säkerställ tillgång till Ajax URL och nonce
        var ajaxUrl = '';
        var nonce = '';
        
        // Kontrollera om bokforehandel finns
        if (typeof bokforehandel !== 'undefined') {
            ajaxUrl = bokforehandel.ajax_url;
            nonce = bokforehandel.nonce;
        } 
        // Annars kontrollera bokforehandel_params
        else if (typeof bokforehandel_params !== 'undefined') {
            ajaxUrl = bokforehandel_params.ajax_url;
            nonce = bokforehandel_params.nonce;
        }
        // Sista utväg, använd adminajax
        else if (typeof ajaxurl !== 'undefined') {
            ajaxUrl = ajaxurl;
        }

        console.log('AJAX URL: ' + ajaxUrl);
        
        // Hantera eventuella globala fel och förhindra att de visas som [object Object]
        window.onerror = function(message, source, lineno, colno, error) {
            console.error('JavaScript-fel:', message, 'på rad', lineno, 'i', source);
            return true; // Förhindra standardfelmeddelandet
        };
        
        // Hantera eventuella ej fångade Promise-fel
        window.addEventListener('unhandledrejection', function(event) {
            console.error('Promise avvisad utan hantering:', event.reason);
            event.preventDefault();
        });
        
        // Dölj alla WordPress admin notices som kan orsaka [object Object]-problemet
        $('.notice, .error, .updated, .notice-error, .notice-warning, .notice-success, .notice-info').remove();
        
        // Ladda körningar direkt vid sidladdning
        loadRuns();
        
        // Visa detaljer för en körning
        $(document).on('click', '.view-run-details', function() {
            var runId = $(this).data('run-id');
            
            // Visa laddningsindikator
            $('.bokforehandel-runs-list').hide();
            $('.bokforehandel-run-details').show();
            $('#run-details-content').html('<p>Laddar detaljer...</p>');
            
            // Hämta körningsdetaljer
            $.ajax({
                url: ajaxUrl || ajaxurl,
                type: 'POST',
                data: {
                    action: 'bokforehandel_get_run_details',
                    run_id: runId,
                    nonce: nonce || '<?php echo wp_create_nonce('bokforehandel_nonce'); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        displayRunDetails(response.data);
                    } else {
                        var errorMsg = response.data && response.data.message ? response.data.message : 'Ett okänt fel inträffade';
                        $('#run-details-content').html('<p>Fel: ' + errorMsg + '</p>');
                    }
                },
                error: function(xhr, status, error) {
                    $('#run-details-content').html('<p>Fel vid hämtning av detaljer: ' + error + '</p>');
                }
            });
        });
        
        // Tillbaka till listan
        $('#back-to-runs').on('click', function() {
            $('.bokforehandel-run-details').hide();
            $('.bokforehandel-runs-list').show();
        });
        
        // Retroaktiv synkronisering
        $('#retro-sync-form').on('submit', function(e) {
            e.preventDefault();
            
            var $form = $(this);
            var $button = $('#run-sync-button');
            
            // Förhindra flera klick - kontrollera om knappen redan är disabled
            if ($button.prop('disabled')) {
                console.log('Synkronisering pågår redan, ignorerar klick');
                return false;
            }
            
            var startDate = $('#sync-start-date').val();
            var endDate = $('#sync-end-date').val();
            
            // Validera datumformat
            if (startDate && !validateDateFormat(startDate)) {
                alert('Startdatum måste anges i formatet ÅÅÅÅMMDD (t.ex. 20230101)');
                return false;
            }
            
            if (endDate && !validateDateFormat(endDate)) {
                alert('Slutdatum måste anges i formatet ÅÅÅÅMMDD (t.ex. 20230101)');
                return false;
            }
            
            $button.prop('disabled', true).text('Synkroniserar...');
            
            // Hämta BL User Key och User ID direkt från PHP
            var blUserKey = '<?php echo esc_js(get_option('bokforehandel_bl_user_key', '')); ?>';
            var wpUserId = '<?php echo esc_js($user_id); ?>';

            // Logga de hämtade nycklarna för felsökning
            console.log('BL User Key hämtad från PHP:', blUserKey ? '***' : 'Saknas!'); // Dölj själva nyckeln
            console.log('WordPress User ID hämtad från PHP:', wpUserId);

            if (!blUserKey) {
                 alert('Fel: Kunde inte hämta pluginets API-nyckel (BL User Key) från inställningarna.');
                 $button.prop('disabled', false).text('Bokför ordrar manuellt'); // Återställ knapp
                 return; // Avbryt om BL User Key saknas
            }
            if (!wpUserId) {
                 alert('Fel: Kunde inte hämta användarens ID (User ID) från PHP för AJAX-anrop.');
                 $button.prop('disabled', false).text('Bokför ordrar manuellt'); // Återställ knapp
                 return; // Avbryt om användar-ID saknas
            }
            
            $.ajax({
                url: ajaxUrl || ajaxurl,
                type: 'POST',
                // Uppdatera headers för att använda rätt nycklar
                headers: {
                    'X-API-Key': blUserKey, // Använd BL User Key här
                    'X-User-ID': wpUserId // Använd WordPress User ID här
                },
                data: {
                    action: 'bokforehandel_run_retro_sync', // TODO: Borde detta vara bokforehandel_manual_sync?
                    operation: $('#sync-operation').val(),
                    start_date: startDate,
                    end_date: endDate,
                    nonce: nonce || '<?php echo wp_create_nonce('bokforehandel_nonce'); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        alert('Synkronisering startad! ID: ' + response.data.run_id);
                        loadRuns();
                        // Behåll knappen disabled tills synken är klar - användaren kan följa förloppet i körningslistan
                        // Knappen kommer att återställas när sidan laddas om eller när körningen är klar
                    } else {
                        var errorMsg = response.data && response.data.message ? response.data.message : 'Ett okänt fel inträffade';
                        alert('Fel: ' + errorMsg);
                        // Återställ knappen vid fel
                        $button.prop('disabled', false).text('Kör synkronisering');
                    }
                },
                error: function(xhr, status, error) {
                    alert('AJAX-fel: ' + error + '. Se konsolen för mer information.');
                    // Återställ knappen vid AJAX-fel
                    $button.prop('disabled', false).text('Kör synkronisering');
                }
            });
        });
        
        // Hjälpfunktioner för formatering och visning
        function getOperationName(operation) {
            switch(operation) {
                case 'all': return 'Allt';
                case 'woo': return 'WooCommerce-ordrar';
                case 'klarna': return 'Klarna-utbetalningar';
                case 'stripe': return 'Stripe-utbetalningar';
                case 'order': return 'WooCommerce-order';
                default: return operation || 'Okänd';
            }
        }

        function getOperationDetails(operation) {
            switch(operation) {
                case 'all': return 'Ordrar + utbetalningar';
                case 'woo': return 'Endast WooCommerce ordrar';
                case 'klarna': return 'Endast Klarna utbetalningar';
                case 'stripe': return 'Endast Stripe utbetalningar';
                case 'order': return 'WooCommerce ordrar';
                default: return 'Okänd operation: ' + (operation || 'N/A');
            }
        }
        
        function formatDateRange(startDate, endDate, run) {
            if (!startDate && !endDate) {
                return 'Alla datum';
            }
            
            if (run && run.date_range === 'all') {
                return 'Alla datum';
            } else if (run && run.date_range === 'lastweek') {
                return 'Senaste veckan';
            } else if (run && run.date_range === 'lastmonth') {
                return 'Senaste månaden';
            }
            
            var formattedStart = startDate ? formatDate(startDate) : '';
            var formattedEnd = endDate ? formatDate(endDate) : '';
            
            if (formattedStart && formattedEnd) {
                return formattedStart + ' till ' + formattedEnd;
            } else if (formattedStart) {
                return 'Från ' + formattedStart;
            } else if (formattedEnd) {
                return 'Till ' + formattedEnd;
            } else {
                return 'Okänt datumintervall';
            }
        }
        
        // Formatera datum från ISO 8601 till läsbart format
        function formatDate(isoDate) {
            if (!isoDate) return '';
            
            // Hantera YYYYMMDD-format
            if (/^\d{8}$/.test(isoDate)) {
                return isoDate.substr(0, 4) + '-' + isoDate.substr(4, 2) + '-' + isoDate.substr(6, 2);
            }
            
            // Hantera ISO-format
            var date = new Date(isoDate);
            if (isNaN(date.getTime())) return isoDate; // Returnera originalet om parsning misslyckas
            
            return date.getFullYear() + '-' + 
                   padZero(date.getMonth() + 1) + '-' + 
                   padZero(date.getDate());
        }
        
        function padZero(num) {
            return num < 10 ? '0' + num : num;
        }
        
        // Formatera datetime från ISO 8601 till läsbart format
        function formatDateTime(isoDate) {
            if (!isoDate) return '';
            
            var date = new Date(isoDate);
            if (isNaN(date.getTime())) return isoDate; // Returnera originalet om parsning misslyckas
            
            return date.getFullYear() + '-' + 
                   padZero(date.getMonth() + 1) + '-' + 
                   padZero(date.getDate()) + ' ' + 
                   padZero(date.getHours()) + ':' + 
                   padZero(date.getMinutes()) + ':' + 
                   padZero(date.getSeconds());
        }
        
        // Kontrollera att datumet har formatet ÅÅÅÅMMDD
        function validateDateFormat(dateStr) {
            if (!dateStr) return true; // Tom sträng är OK
            
            // Kontrollera att det är exakt 8 siffror
            return /^\d{8}$/.test(dateStr);
        }
        
        // Visa körningsdetaljer
        function displayRunDetails(run) {
            var detailsHtml = '<div class="run-details">';
            detailsHtml += '<h3>Körningsdetaljer</h3>';

            // Grundläggande information
            detailsHtml += '<table class="wp-list-table widefat fixed">';
            detailsHtml += '<tr><td><strong>ID</strong></td><td>' + (run.id || 'N/A') + '</td></tr>';
            detailsHtml += '<tr><td><strong>Synkat</strong></td><td>' + getOperationName(run.operation) + '</td></tr>';
            detailsHtml += '<tr><td><strong>Status</strong></td><td>' + formatStatus(run.status) + '</td></tr>';

            // Visa datumintervall
            if (run.saved_start_date || run.saved_end_date) {
                detailsHtml += '<tr><td><strong>Synkat datumintervall</strong></td><td>' +
                    formatDateRange(run.saved_start_date, run.saved_end_date) + '</td></tr>';
            }

            detailsHtml += '<tr><td><strong>Startad</strong></td><td>' + formatDateTime(run.created_at) + '</td></tr>';
            detailsHtml += '<tr><td><strong>Körtid</strong></td><td>' + (run.run_time || '0') + ' sek</td></tr>';

            // Förbättrad visning av synkroniserade objekt
            detailsHtml += '<tr><td><strong>Antal synkroniserade objekt</strong></td><td>' + ((run.items_processed != null && run.items_processed !== '') ? run.items_processed : 0) + '</td></tr>';

            // Detaljerad breakdown för varje typ
            var hasDetails = false;

            if (run.orders_count !== undefined && run.orders_count !== null) {
                detailsHtml += '<tr><td><strong>📦 WooCommerce Ordrar</strong></td><td>' + run.orders_count + ' st</td></tr>';
                hasDetails = true;
            }
            if (run.klarna_count !== undefined && run.klarna_count !== null) {
                detailsHtml += '<tr><td><strong>💳 Klarna Utbetalningar</strong></td><td>' + run.klarna_count + ' st</td></tr>';
                hasDetails = true;
            }
            if (run.stripe_count !== undefined && run.stripe_count !== null) {
                detailsHtml += '<tr><td><strong>💰 Stripe Utbetalningar</strong></td><td>' + run.stripe_count + ' st</td></tr>';
                hasDetails = true;
            }

            // Om vi inte har detaljerad breakdown, visa operation
            if (!hasDetails) {
                var operationDetails = getOperationDetails(run.operation);
                if (operationDetails) {
                    detailsHtml += '<tr><td><strong>Detaljer</strong></td><td>' + operationDetails + '</td></tr>';
                }
            }

            detailsHtml += '</table>';
            
            // Visa journalposter om de finns
            if (run.journal_posts && run.journal_posts.length > 0) {
                detailsHtml += '<h3>📄 Journalposter</h3>';
                detailsHtml += '<div class="journal-posts-container">';
                $.each(run.journal_posts, function(i, post) {
                    var cleanedPost = post.replace(/["']/g, '');
                    // Försök extrahera journalpostnummer för bättre visning
                    var journalMatch = cleanedPost.match(/Journalpost ([WKA]\d+)/);
                    if (journalMatch) {
                        var journalNumber = journalMatch[1];
                        var description = cleanedPost.replace(journalMatch[0], '').trim();
                        detailsHtml += '<div class="journal-post-item">';
                        detailsHtml += '<strong>' + journalNumber + '</strong>';
                        if (description) {
                            detailsHtml += '<br><small>' + description + '</small>';
                        }
                        detailsHtml += '</div>';
                    } else {
                        detailsHtml += '<div class="journal-post-item">' + cleanedPost + '</div>';
                    }
                });
                detailsHtml += '</div>';
            }

            // Visa ordrar och utbetalningar om de finns (nya fält)
            if (run.orders && run.orders.length > 0) {
                detailsHtml += '<h3>📦 Synkroniserade Ordrar</h3>';
                detailsHtml += '<div class="orders-container">';
                $.each(run.orders, function(i, order) {
                    detailsHtml += '<div class="order-item">';
                    detailsHtml += '<strong>Order #' + order.order_id + '</strong>';
                    detailsHtml += ' - ' + getPaymentMethodName(order.payment_method);
                    detailsHtml += ' - ' + formatCurrency(order.amount) + ' kr';
                    detailsHtml += '</div>';
                });
                detailsHtml += '</div>';
            }

            if (run.settlements && run.settlements.length > 0) {
                detailsHtml += '<h3>💳 Synkroniserade Utbetalningar</h3>';
                detailsHtml += '<div class="settlements-container">';
                $.each(run.settlements, function(i, settlement) {
                    detailsHtml += '<div class="settlement-item">';
                    detailsHtml += '<strong>' + settlement.payment_method.toUpperCase() + '</strong>';
                    detailsHtml += ' - ' + (settlement.payout_id || settlement.settlement_id || 'Okänt ID');
                    detailsHtml += ' - ' + formatCurrency(settlement.amount) + ' kr';
                    detailsHtml += '</div>';
                });
                detailsHtml += '</div>';
            }

            // Visa felmeddelanden om de finns
            if (run.status === 'failed' && run.errors && run.errors.length > 0) {
                detailsHtml += '<h3>❌ Fel</h3>';
                detailsHtml += '<ul class="bokforehandel-error-list">';
                $.each(run.errors, function(i, error) {
                    var errorMessage = error.message || error;
                    detailsHtml += '<li>' + errorMessage + '</li>';
                });
                detailsHtml += '</ul>';
            } else if (run.status === 'completed') {
                detailsHtml += '<div class="success-message">✅ Synkronisering slutfördes framgångsrikt!</div>';
            }
            
            $('#run-details-content').html(detailsHtml);
        }
        
        // Formatera status
        function formatStatus(status) {
            switch(status) {
                case 'completed': return '<span class="status-completed">Slutförd</span>';
                case 'running': return '<span class="status-running">Pågår</span>';
                case 'failed': return '<span class="status-failed">Misslyckad</span>';
                case 'waiting': return '<span class="status-waiting">Väntar</span>';
                default: return status || 'Okänd';
            }
        }

        function getPaymentMethodName(method) {
            switch(method) {
                case 'kco': return 'Klarna Checkout';
                case 'klarna_checkout': return 'Klarna Checkout';
                case 'klarna': return 'Klarna';
                case 'stripe': return 'Stripe';
                case 'bacs': return 'Banköverföring';
                case 'cod': return 'Kontant vid leverans';
                case 'paypal': return 'PayPal';
                default: return method || 'Okänd';
            }
        }

        function formatCurrency(amount) {
            var num = parseFloat(amount);
            if (isNaN(num)) return '0';
            return num.toLocaleString('sv-SE', {minimumFractionDigits: 2, maximumFractionDigits: 2});
        }
        
        // Ladda körningar
        function loadRuns() {
            var $tableBody = $('#runs-table-body');
            $tableBody.html('<tr><td colspan="7">Laddar synkroniseringshistorik...</td></tr>');
            
            try {
                $.ajax({
                    url: ajaxUrl || ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'bokforehandel_get_runs',
                        nonce: nonce || '<?php echo wp_create_nonce('bokforehandel_nonce'); ?>'
                    },
                    success: function(response) {
                        try {
                            console.log('Mottaget API-svar:', response);
                            
                            var runs = [];
                            
                            try {
                                // Hantera olika API-svarsformat
                                if (response && response.success && response.data) {
                                    // WordPress standardformat
                                    if (Array.isArray(response.data)) {
                                        runs = response.data;
                                        console.log('Response.data är en array med ' + runs.length + ' objekt');
                                    } else if (response.data.runs && Array.isArray(response.data.runs)) {
                                        runs = response.data.runs;
                                        console.log('Response.data.runs är en array med ' + runs.length + ' objekt');
                                    } else if (Array.isArray(response.data.data)) {
                                        // Hantera fall där data är i response.data.data
                                        runs = response.data.data;
                                        console.log('Response.data.data är en array med ' + runs.length + ' objekt');
                                    } else {
                                        console.log('Response.data är inte en array:', response.data);
                                        // Försök konvertera om det är ett objekt med värden
                                        if (typeof response.data === 'object' && response.data !== null) {
                                            var dataArray = [];
                                            for (var key in response.data) {
                                                if (response.data.hasOwnProperty(key)) {
                                                    dataArray.push(response.data[key]);
                                                }
                                            }
                                            if (dataArray.length > 0) {
                                                console.log('Konverterade response.data objekt till array med ' + dataArray.length + ' objekt');
                                                runs = dataArray;
                                            }
                                        }
                                    }
                                } else if (response && response.data && Array.isArray(response.data)) {
                                    // API format från loggarna: {data: [...], status: "success"}
                                    runs = response.data;
                                } else if (response && Array.isArray(response)) {
                                    // Direkta array-format
                                    runs = response;
                                } else {
                                    // Sista fallback: Manuell parsing av serverlogs format
                                    console.log('Försöker manuell fallback-parsing av serverloggar...');
                                    try {
                                        // Baserat på serverlogs-formatet:
                                        // {"data":[{"created_at":"2025-03-06T22:44:01"...
                                        if (response && typeof response === 'string') {
                                            var parsedResponse = JSON.parse(response);
                                            if (parsedResponse && parsedResponse.data && Array.isArray(parsedResponse.data)) {
                                                console.log('Manuell parsing lyckades, hittade ' + parsedResponse.data.length + ' objekt');
                                                runs = parsedResponse.data;
                                            }
                                        } else if (response && response.data && typeof response.data === 'string') {
                                            var parsedData = JSON.parse(response.data);
                                            if (Array.isArray(parsedData)) {
                                                console.log('Parsad response.data string, hittade ' + parsedData.length + ' objekt');
                                                runs = parsedData;
                                            }
                                        }
                                    } catch(parseError) {
                                        console.error('Fel vid fallback-parsing:', parseError);
                                    }
                                    
                                    // Om vi fortfarande inte har några körningar, visa felmeddelande
                                    if (runs.length === 0) {
                                        var msg = "Inga körningar hittades";
                                        if (response && response.data && typeof response.data.message === 'string') {
                                            msg = response.data.message;
                                        } else if (response && typeof response.message === 'string') {
                                            msg = response.message;
                                        } else if (response && response.status === 'success' && (!response.data || response.data.length === 0)) {
                                            msg = "API-anropet lyckades men inga körningar hittades";
                                        }
                                        console.log('API-svar som inte kunde tolkas:', response);
                                        $tableBody.html('<tr><td colspan="7">' + msg + '</td></tr>');
                                        return;
                                    }
                                }
                            } catch (formatError) {
                                console.error('Fel vid tolkning av API-svaret:', formatError);
                            }

                            console.log('Efter all formathantering, runs är:', runs);
                            console.log('Typ av runs:', typeof runs);
                            console.log('Är runs en array:', Array.isArray(runs));
                            
                            // Sista försök: direktåtkomst av response.data.runs som loggarna visar
                            if ((!runs || runs.length === 0) && response && response.data && response.data.runs) {
                                console.log('Försöker direktåtkomst av response.data.runs');
                                runs = response.data.runs;
                            }
                            
                            if (!runs || runs.length === 0) {
                                console.log('Inga körningar kunde hittas i API-svaret');
                                $tableBody.html('<tr><td colspan="7">Inga körningar hittades. Kör synkronisering för att börja bokföra dina ordrar.</td></tr>');
                                return;
                            }
                            
                            console.log("Runs innan vi visar dem:", runs);
                            console.log("Runs längd:", runs.length);
                            
                            $tableBody.empty();
                            
                            try {
                                // Visa bara de 20 senaste körningarna
                                var recentRuns = runs.slice(0, 20);
                                console.log("Klipper ut de 20 senaste körningarna:", recentRuns.length);
                                
                                // Visa alla körningar utan paginering
                                var rowsAdded = 0;
                                $.each(recentRuns, function(i, run) {
                                    console.log("Skapar rad för körning", i, run.id);
                                    var row = createRunRow(run);
                                    $tableBody.append(row);
                                    rowsAdded++;
                                });
                                
                                console.log("Antal rader tillagda till tabellen:", rowsAdded);
                            
                                if (runs.length > 20) {
                                    $tableBody.append('<tr><td colspan="7" class="more-runs-note">Visar de 20 senaste körningarna av totalt ' + runs.length + '.</td></tr>');
                                }
                                
                                // Force re-render av tabellen
                                $tableBody.hide().show(0);
                            } catch (displayError) {
                                console.error("Fel vid visning av körningar:", displayError);
                                $tableBody.html('<tr><td colspan="7">Ett fel inträffade vid visning av körningar: ' + displayError.message + '</td></tr>');
                            }
                        } catch (innerError) {
                            console.error('Fel vid bearbetning av körningsdata:', innerError);
                            $tableBody.html('<tr><td colspan="7">Ett fel inträffade vid bearbetning av körningsdata</td></tr>');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX-fel:', xhr, status, error);
                        $tableBody.html('<tr><td colspan="7">Fel vid hämtning av körningar: ' + error + '</td></tr>');
                    }
                });
            } catch (error) {
                console.error('Fel vid försök att ladda körningar:', error);
                $tableBody.html('<tr><td colspan="7">Ett fel inträffade vid laddning av körningar</td></tr>');
            }
        }
        
        // Skapa en rad för en körning
        function createRunRow(run) {
            try {
                console.log("Skapar rad för körning med ID:", run.id);
                
                var rowHtml = '<tr>';
                rowHtml += '<td>' + (run.id || 'N/A') + '</td>';
                rowHtml += '<td>' + formatDateTime(run.created_at) + '</td>';
                rowHtml += '<td><span class="operation-badge operation-' + run.operation + '">' + 
                    getOperationName(run.operation) + '</span></td>';
                
                // Status med färgkodning
                var statusClass = '';
                switch(run.status) {
                    case 'completed': statusClass = 'status-completed'; break;
                    case 'running': statusClass = 'status-running'; break;
                    case 'failed': statusClass = 'status-failed'; break;
                    case 'waiting': statusClass = 'status-waiting'; break;
                }
                
                rowHtml += '<td><span class="status-badge ' + statusClass + '">' + 
                    (run.status === 'completed' ? 'Slutförd' : 
                     run.status === 'running' ? 'Pågår' : 
                     run.status === 'failed' ? 'Misslyckad' : 
                     run.status === 'waiting' ? 'Väntar' : run.status || 'Okänd') + 
                    '</span></td>';
                
                // Antal objekt
                var count = ( (run.items_processed != null && run.items_processed !== '') ? run.items_processed : ((run.orders_count != null && run.orders_count !== '') ? run.orders_count : ((run.items_count != null && run.items_count !== '') ? run.items_count : 0)) );
                rowHtml += '<td>' + count + '</td>';
                
                // Körtid
                rowHtml += '<td>' + (run.run_time || '0') + ' sek</td>';
                
                // Åtgärder
                rowHtml += '<td><button type="button" class="button button-secondary view-run-details" data-run-id="' + run.id + '" data-sync-details="' + ( run.sync_details ? run.sync_details : 'Ingen detaljer' ) + '">Visa detaljer</button></td>';
                
                rowHtml += '</tr>';
                console.log("Rad skapad utan fel");
                return rowHtml;
            } catch (error) {
                console.error("Fel när rad skulle skapas för körning:", error);
                // Skapa en enkel rad med felmeddelande om något går fel
                return '<tr><td colspan="7">Fel vid visning av körning: ' + error.message + '</td></tr>';
            }
        }
    });
</script>

<script type="text/javascript">
    // Försäkra oss om att tabellen visas, oavsett CSS
    jQuery(document).ready(function($) {
        setTimeout(function() {
            console.log("Tvingar synlighet för tabellvisning...");
            $('.bokforehandel-tab').css('display', 'block');
            $('.bokforehandel-runs-table').css('display', 'table');
        }, 500);
    });
</script>

<style>
.bokforehandel-runs-container {
    margin-top: 20px;
}

.bokforehandel-runs-table {
    border-collapse: collapse;
    width: 100%;
    margin-top: 15px;
}

.bokforehandel-runs-table th {
    text-align: left;
    padding: 10px;
    font-weight: bold;
}

.bokforehandel-runs-table td {
    padding: 12px 10px;
    vertical-align: middle;
}

.operation-badge, .status-badge {
    display: inline-block;
    padding: 4px 10px;
    border-radius: 4px;
    font-size: 13px;
    font-weight: bold;
    text-align: center;
}

.operation-all {
    background-color: #e0f7fa;
    color: #006064;
}

.operation-woo {
    background-color: #e8f5e9;
    color: #1b5e20;
}

.operation-klarna {
    background-color: #f3e5f5;
    color: #4a148c;
}

.operation-stripe {
    background-color: #fff3e0;
    color: #e65100;
}

.operation-order {
    background-color: #e8f5e9;
    color: #1b5e20;
}

.status-completed {
    background-color: #e8f5e9;
    color: #1b5e20;
}

.status-running {
    background-color: #e3f2fd;
    color: #0d47a1;
}

.status-failed {
    background-color: #ffebee;
    color: #b71c1c;
}

.status-waiting {
    background-color: #fff9c4;
    color: #f57f17;
}

.run-details {
    margin-top: 15px;
}

.bokforehandel-error-list {
    margin-left: 20px;
    color: #b71c1c;
    background-color: #ffebee;
    padding: 10px;
    border-radius: 4px;
}

.bokforehandel-retro-sync-box {
    background-color: #fff;
    border: 1px solid #ccd0d4;
    box-shadow: 0 1px 1px rgba(0,0,0,.04);
}

.form-fields {
    margin-top: 10px;
}

.form-field {
    margin-bottom: 10px;
}

.form-field label {
    display: block;
    margin-bottom: 5px;
    font-weight: 600;
}

.description {
    font-style: italic;
    color: #666;
    margin-top: 5px;
    margin-bottom: 15px;
}

.more-runs-note {
    text-align: center;
    font-style: italic;
    background-color: #f8f9fa;
    padding: 8px;
}

/* Nya stilar för förbättrad visning */
.journal-posts-container {
    background-color: #f8f9fa;
    border: 1px solid #ddd;
    border-radius: 6px;
    padding: 15px;
    margin-bottom: 20px;
}

.journal-post-item {
    background-color: white;
    border: 1px solid #e0e0e0;
    border-radius: 4px;
    padding: 10px;
    margin-bottom: 8px;
    font-family: 'Courier New', monospace;
}

.journal-post-item strong {
    color: #006400;
}

.journal-post-item small {
    color: #666;
    font-style: italic;
}

.orders-container, .settlements-container {
    background-color: #f0f8ff;
    border: 1px solid #b3d9ff;
    border-radius: 6px;
    padding: 15px;
    margin-bottom: 20px;
}

.order-item, .settlement-item {
    background-color: white;
    border: 1px solid #cce5ff;
    border-radius: 4px;
    padding: 12px;
    margin-bottom: 8px;
    display: flex;
    align-items: center;
    gap: 10px;
}

.order-item:hover, .settlement-item:hover {
    background-color: #f5f9ff;
}

.success-message {
    background-color: #e8f5e9;
    border: 1px solid #4caf50;
    color: #2e7d32;
    padding: 15px;
    border-radius: 6px;
    text-align: center;
    font-weight: bold;
    margin-top: 20px;
}

.bokforehandel-error-list {
    margin-left: 20px;
    color: #b71c1c;
    background-color: #ffebee;
    padding: 10px;
    border-radius: 4px;
    border-left: 4px solid #f44336;
}

.bokforehandel-error-list li {
    margin-bottom: 5px;
    padding: 5px 0;
}

.bokforehandel-error-list li:last-child {
    margin-bottom: 0;
}
</style>
<?php
// Avsluta filen med PHP-tagg
?>