<?php
// Förhindra att sidan renderas flera gånger
global $bokforehandel_help_rendered;
if (isset($bokforehandel_help_rendered) && $bokforehandel_help_rendered === true) {
    return;
}
$bokforehandel_help_rendered = true;

// Säkerställ att admin_url används korrekt
if (!function_exists('admin_url')) {
    exit('Denna fil kan endast köras i WordPress-miljö.');
}

// Ladda CSS
wp_enqueue_style('bokforehandel-admin-help', plugin_dir_url(__FILE__) . '../assets/css/admin-help.css', [], '1.0.0');

// Ladda dashicons
wp_enqueue_style('dashicons');

// Datum för senaste uppdatering
$last_updated = '2025-03-30 '; // Uppdatera detta datum när innehållet ändras
?>

<div class="wrap bokforehandel-admin" id="top">
    <h1 class="wp-heading-inline">Bokför Ehandel – Hjälp & Support</h1>
    
    <div class="bokforehandel-admin-content">
        <!-- Innehållsförteckning -->
        <div class="bokforehandel-toc">
            <h3>Innehåll</h3>
            <ul>
                <li><a href="#komma-igang">Kom igång</a></li>
                <li><a href="#installation">Installationsguide</a></li>
                <li><a href="#faq">Vanliga frågor</a>
                    <ul>
                        <li><a href="#faq-installation">Installation & Konfiguration</a></li>
                        <li><a href="#faq-anvandning">Användning</a></li>
                        <li><a href="#faq-felsok">Felsökning</a></li>
                    </ul>
                </li>
                <li><a href="#bokforing">Mer om bokföring</a></li>
                <li><a href="#gdpr">GDPR & Dataskydd</a></li>
                <li><a href="#kontakt">Kontakta oss</a></li>
            </ul>
        </div>
        
        <section id="komma-igang" class="help-section">
            <h2>Kom igång</h2>
            <p>Kul att du är här! Med Bokför Ehandel fixar du bokföringen av dina WooCommerce-ordrar till Bjorn Lunden på ett kick. Följ stegen nedan så är du igång!</p>
            
            <div class="bokforehandel-setup-steps bokforehandel-card">
                <div class="step">
                    <div class="step-number">1</div>
                    <div class="step-content">
                        <h3>Aktivera integrationen i Bjorn Lunden</h3>
                        <p>Börja med att koppla på integrationen hos Bjorn Lunden – superenkelt:</p>
                        <ol>
                            <li>Logga in på <a href="https://app.bjornlunden.se" target="_blank">Bjorn Lunden</a>.</li>
                            <li>Klicka på <strong>Integrationer</strong> i menyn.</li>
                            <li>Leta upp <strong>Bokför Ehandel</strong>.</li>
                            <li>Klicka på <strong>Aktivera</strong> och följ stegen.</li>
                        </ol>
                        <div class="bokforehandel-notice notice-info inline">
                            <p><strong>Tips:</strong> Integrationen måste vara igång här för att allt ska funka. Kolla statusen på inställningssidan när du lagt in organisationsnummer och nyckel!</p>
                        </div>
                        
                        
                        <a href="https://app.bjornlunden.se" target="_blank" class="button">Gå till Bjorn Lunden</a>
                    </div>
                </div>
                
                <div class="step">
                    <div class="step-number">2</div>
                    <div class="step-content">
                        <h3>Hämta din API-nyckel</h3>
                        <p>För att koppla pluginet till Bjorn Lunden behöver du din publika API-nyckel:</p>
                        <ol>
                            <li>Logga in på <a href="https://app.bjornlunden.se" target="_blank">Bjorn Lunden</a>.</li>
                            <li>Gå till <strong>Integrationer</strong> i menyn.</li>
                            <li>Klicka på kugghjulet och kopiera din <strong>API-nyckel</strong> (Tips: Spara den någonstans säkert!)</li>
                        </ol>
                        
                        <div class="screenshot-container">
                            <img src="<?php echo plugin_dir_url(__FILE__) . '../assets/images/bl-api-nyckel.jpg'; ?>" alt="Hitta API-nyckel i Bjorn Lunden">
                            <p class="screenshot-caption">Hur du hittar din API-nyckel i Bjorn Lunden</p>
                        </div>
                        
                        <a href="https://app.bjornlunden.se" target="_blank" class="button">Hämta nyckel</a>
                    </div>
                </div>
                
                <div class="step">
                    <div class="step-number">3</div>
                    <div class="step-content">
                        <h3>API-nycklar i WooCommerce</h3>
                        <p>Skönt nog skapas WooCommerce API-nycklar automatiskt – du behöver inte göra något här!</p>
                        <div class="bokforehandel-notice notice-info inline">
                            <p><strong>Teknisk info:</strong> Pluginet skapar och hanterar automatiskt rätt behörigheter för WooCommerce API. Du kan se dessa nycklar under WooCommerce > Inställningar > Avancerat > REST API, men du behöver inte ändra något där.</p>
                        </div>
                    </div>
                </div>
                
                <div class="step">
                    <div class="step-number">4</div>
                    <div class="step-content">
                        <h3>Ställ in pluginet</h3>
                        <p>På sidorna <strong>Företag & API</strong> och <strong>Bokföring</strong> kan du:</p>
                        <ul>
                            <li>Ange <strong>företagsuppgifter</strong> som namn och organisationsnummer.</li>
                            <li>Koppla <strong>betalningsmetoder</strong> till bokföringskonton.</li>
                            <li>Lägga in din <strong>API-nyckel</strong> från Bjorn Lunden (din ID mot servern).</li>
                            <li>Aktivera <strong>Klarna/Stripe</strong> – kryssa i rutan och ange deras API-nycklar (se nedan hur du hittar dem).</li>
                            <li>Välja <strong>konton</strong> för olika transaktioner.</li>
                            <li>Starta <strong>manuell synkronisering</strong> för ett datumintervall.</li>
                        </ul>
                        
                        
                        <p><strong>Hämta Klarna API-nycklar:</strong></p>
                        <ol>
                            <li>Logga in på din Klarna företagssida.</li>
                            <li>Gå till <strong>Inställningar</strong> &gt; <strong>Klarna API-nycklar</strong>.</li>
                            <li>Klicka på <strong>Generera ny Klarna API-nyckel</strong>.</li>
                            <li>Kopiera Användarnamn och Lösenord. Klistra in dem i under Bokföringsinställningar.</li>
                        </ol>
                        
                        <div class="screenshot-container">
                            <img src="<?php echo plugin_dir_url(__FILE__) . '../assets/images/klarna-api-keys.jpg'; ?>" alt="Hitta API-nycklar i Klarna">
                            <p class="screenshot-caption">Hur du hittar dina API-nycklar i Klarna</p>
                        </div>
                        
                        <p><strong>Hämta Stripe API-nycklar:</strong></p>
                        <ol>
                            <li>Logga in på Stripe Dashboard.</li>
                            <li>Klicka på <strong>Utvecklare</strong> &gt; <strong>API-nycklar</strong> &gt; Skapa begränsad nyckel.</li>
                            <li>Välj <strong>Ge den här nyckeln till en annan webbplats</strong>. Fyll i Bokför Ehandel som namn och <strong>https://www.bokforehandel.se</strong> som webbplats.</li>
                            <li>Identifera dig och kopiera din <strong>API-nyckel.</strong> Klistra in den i pluginets Bokföringsinställningar.</li>
                        </ol>
                        
                        <div class="screenshot-container">
                            <img src="<?php echo plugin_dir_url(__FILE__) . '../assets/images/stripe-api-keys.jpg'; ?>" alt="Hitta API-nycklar i Stripe">
                            <p class="screenshot-caption">Bild: Hur du hittar dina API-nycklar i Stripe</p>
                        </div>
                        <div class="screenshot-container">
                            <img src="<?php echo plugin_dir_url(__FILE__) . '../assets/images/stripe-api-keys2.jpg'; ?>" alt="Hitta API-nycklar i Stripe">
                            <p class="screenshot-caption">Bild: Hur du hittar dina API-nycklar i Stripe</p>
                        </div>
                        
                        
                        <a href="<?php echo esc_url(admin_url('admin.php?page=bokforehandel-company')); ?>" class="button">Gå till inställningar</a>
                    </div>
                </div>
                
                <div class="step">
                    <div class="step-number">5</div>
                    <div class="step-content">
                        <h3>Starta synkroniseringen</h3>
                        <p>När allt är klart, välj hur du vill bokföra:</p>
                        <ul>
                            <li><strong>Automatiskt:</strong> Ordrar och utbetalningar bokförs varje natt kl 02. Vi rekommenderar att du lämnar detta på</li>
                            <li><strong>Manuellt:</strong> Välj ett datumintervall och synkronisera efter behov. Framförallt kan du synkronisera fram till igår manuellt, därefter låta den automatiska synkroniseringen bokföra åt dig.</li>
                        </ul>
                        
                        <div class="screenshot-container">
                            <img src="<?php echo plugin_dir_url(__FILE__) . '../assets/images/sync-page.jpg'; ?>" alt="Synkroniseringssidan">
                            <p class="screenshot-caption">Synkroniseringssidan i pluginet</p>
                        </div>
                        
                        <div class="bokforehandel-notice notice-info inline">
                            <p><strong>Tips:</strong> Använd <strong>Testa anslutning</strong> först för att kolla att allt funkar innan du försöker synkronisera.</p>
                            <p><strong>Kom också ihåg att fylla i alla bokföringskonton och alla inställningar innan du startar en synkronisering!</strong></p>

                        </div>
                        
                        <a href="<?php echo esc_url(admin_url('admin.php?page=bokforehandel-runs')); ?>" class="button">Gå till Synkroniseringar</a>
                    </div>
                </div>
            </div>
            
            <div class="bokforehandel-checklist">
                <h3>Redo att köra? Dubbelkolla:</h3>
                <ul>
                    <li>☑ Integration aktiverad i Bjorn Lunden</li>
                    <li>☑ API-nyckel inskriven</li>
                    <li>☑ Inställningar sparade</li>
                    <li>☑ Testat anslutningen</li>
                </ul>
                <p>Allt klart? Då är det bara att synka och låta bokföringen sköta sig själv!</p>
            </div>
            
            <div class="text-right">
                <a href="#top" class="back-to-top-link">Tillbaka till toppen ↑</a>
            </div>
        </section>
        
        <section id="faq" class="help-section">
            <h2>Vanliga frågor</h2>
            
            <div class="bokforehandel-faq bokforehandel-card">
                <!-- FAQ: Installation & Konfiguration -->
                <div id="faq-installation" class="bokforehandel-faq-category">
                    <h3 class="bokforehandel-faq-category-title">Installation & Konfiguration</h3>
                    
                    <div class="bokforehandel-faq-item bokforehandel-notice">
                        <h4>Vad betyder "Ej aktiverad"?</h4>
                        <div class="bokforehandel-faq-answer">
                            <p>Integrationen är inte igång i Bjorn Lunden. Så här fixar du det:</p>
                            <ol>
                                <li>Logga in på Bjorn Lunden.</li>
                                <li>Gå till <strong>Integrationer</strong>.</li>
                                <li>Hitta <strong>Bokför Ehandel</strong>.</li>
                                <li>Klicka <strong>Aktivera</strong> och välj företag.</li>
                            </ol>
                            <p>Status uppdateras i pluginet inom en minut. Funkar det inte? Kolla att du fyllt i organisationsnumret och din publika nyckel rätt!</p>
                            
                            <div class="screenshot-container">
                                <img src="<?php echo plugin_dir_url(__FILE__) . '../assets/images/bl-integration-status.jpg'; ?>" alt="Integration status i Bjorn Lunden">
                                <p class="screenshot-caption">Status för integrationen i Bjorn Lunden</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bokforehandel-faq-item bokforehandel-notice">
                        <h4>Hur ser jag om integrationen funkar?</h4>
                        <div class="bokforehandel-faq-answer">
                            <p>Kolla på två ställen:</p>
                            <ul>
                                <li><strong>I WordPress:</strong> Se status på inställningssidan (uppdateras var 60:e sekund).</li>
                                <li><strong>I Bjorn Lunden:</strong> Gå till <strong>Integrationer</strong> och se att integrationen är aktiverad.</li>
                            </ul>
                            
                            <div class="screenshot-container">
                                <img src="<?php echo plugin_dir_url(__FILE__) . '../assets/images/plugin-status.jpg'; ?>" alt="Status i pluginet">
                                <p class="screenshot-caption">Status i pluginet</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- FAQ: Användning -->
                <div id="faq-anvandning" class="bokforehandel-faq-category">
                    <h3 class="bokforehandel-faq-category-title">Användning</h3>
                    
                    <div class="bokforehandel-faq-item bokforehandel-notice">
                        <h4>Hur ofta bokförs ordrar?</h4>
                        <div class="bokforehandel-faq-answer">
                            <p>Ordar och utbetalningarbokförs automatiskt varje natt kl 02 om du aktiverat automatisk synkronisering.</p>
                        </div>
                    </div>
                    
                    <div class="bokforehandel-faq-item bokforehandel-notice">
                        <h4>Vilka betalningsmetoder funkar?</h4>
                        <div class="bokforehandel-faq-answer">
                            <p>Alla betalningsmetoder stöds för orderbokföring! Men för automatiska utbetalningar stöds just nu:</p>
                            <ul>
                                <li><strong>Klarna</strong> - Komplett integration för ordrar och utbetalningar</li>
                                <li><strong>Stripe</strong> - Komplett integration för ordrar och utbetalningar</li>
                                <li><strong>Direktbetalningar</strong> (Swish t ex) - Bokförs direkt mot konto bankkonto (eller som du ställt in.)</li>
                            </ul>
                            <p>För övriga betalningsmetoder bokförs ordrar automatiskt, men utbetalningar behöver bokföras manuellt i Bjorn Lunden.</p>
                            <div class="bokforehandel-notice notice-info inline">
                                <p>Önskar du integration för fler betalningsmetoder? Hör av dig till oss på <a href="mailto:support@bokforehandel.se">support@bokforehandel.se</a> så ser vi om vi kan ordna det.</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bokforehandel-faq-item bokforehandel-notice">
                        <h4>Hur bokförs ordrar?</h4>
                        <div class="bokforehandel-faq-answer">
                            <p>Just nu stöds endast ordrar i Sverige med 25% moms. Finns behov av fler momssatser, hör av dig så ordnar vi det.</p>
                            <div class="code-example bokforehandel-code-block">
                                <pre>
Kredit (3001): Försäljning exkl. moms
Kredit (2610): Utgående moms
Debet (1580/1930): Totalbelopp inkl. moms
                                </pre>
                            </div>
                            <p>Gäller ordrar med status "Färdigbehandlad" och återbetalningar. Även återbetalningar (hela och delvisa) bokförs.</p>
                            <p>Du kan anpassa kontonummer i pluginets inställningar.</p>
                        </div>
                    </div>
                    
                    <div class="bokforehandel-faq-item bokforehandel-notice">
                        <h4>Hur bokförs Klarna/Stripe-utbetalningar?</h4>
                        <div class="bokforehandel-faq-answer">
                            <p>Utbetalningar hämtas via API och bokförs automatiskt kl 02 (om aktiverat):</p>
                            <div class="code-example bokforehandel-code-block">
                                <pre>
Debet (1930): Utbetalning till bank
Kredit (1580): Bruttosumma
Debet (6064): Avgifter exkl. moms
Debet (2640): Ingående moms på avgifter
                                </pre>
                            </div>
                            <div class="screenshot-container">
                                <img src="<?php echo plugin_dir_url(__FILE__) . '../assets/images/utbetalning-exempel.jpg'; ?>" alt="Exempel på bokförd utbetalning">
                                <p class="screenshot-caption">Exempel på bokförd utbetalning i Bjorn Lunden</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bokforehandel-faq-item bokforehandel-notice">
                        <h4>Hur hanteras återbetalningar?</h4>
                        <div class="bokforehandel-faq-answer">
                            <p>Återbetalningar bokförs automatiskt med omvända poster:</p>
                            <div class="code-example bokforehandel-code-block">
                                <pre>
Debet (3001): Återbetalning exkl. moms
Debet (2610): Utgående moms
Kredit (1580/1930): Totalbelopp inkl. moms
                                </pre>
                            </div>
                            <p>Återbetalningar hanteras när en order markeras som återbetald i WooCommerce.</p>
                        </div>
                    </div>
                    
                    <div class="bokforehandel-faq-item bokforehandel-notice">
                        <h4>Kan jag bokföra gamla ordrar?</h4>
                        <div class="bokforehandel-faq-answer">
                            <p>Ja, så här:</p>
                            <ol>
                                <li>Gå till <strong>Synkroniseringar</strong>.</li>
                                <li>Välj datumintervall och vad du vill bokföra.</li>
                                <li>Klicka <strong>Starta</strong>.</li>
                            </ol>
                            <p>Perfekt för att komma ikapp – sen tar automatiken över!</p>
                            <div class="bokforehandel-notice notice-warning inline">
                                <p><strong>OBS:</strong> Var försiktig så att du inte bokför samma ordrar flera gånger!</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bokforehandel-faq-item bokforehandel-notice">
                        <h4>Skapas bokföringsunderlag?</h4>
                        <div class="bokforehandel-faq-answer">
                            <p>Ja! För varje bokföring skapas ett underlag som laddas upp till Bjorn Lunden:</p>
                            <ul>
                                <li><strong>Ordrar:</strong> Automatiskt genererade underlag med orderinformation</li>
                                <li><strong>Klarna-utbetalningar:</strong> Klarnas egna utbetalningsrapporter</li>
                                <li><strong>Stripe-utbetalningar:</strong> Automatiskt genererade underlag baserade på Stripe-data</li>
                            </ul>
                            <p>Underlagen kan ses i Bjorn Lunden kopplat till varje verifikation.</p>
                        </div>
                    </div>
                </div>
                
                <!-- FAQ: Felsökning -->
                <div id="faq-felsok" class="bokforehandel-faq-category">
                    <h3 class="bokforehandel-faq-category-title">Felsökning</h3>
                    
                    <div class="bokforehandel-faq-item bokforehandel-notice">
                        <h4>Varför kan jag inte synkronisera ordrar?</h4>
                        <div class="bokforehandel-faq-answer">
                            <p>Kan inte synka? Testa detta:</p>
                            <ul>
                                <li>Är integrationen <strong>inaktiv</strong>? Kolla status.</li>
                                <li>Fel <strong>API-nyckel</strong>? Jämför med Bjorn Lunden.</li>
                                <li><strong>Nätverksproblem</strong>? Klicka "Testa anslutning".</li>
                                <li>Saknas <strong>inställningar</strong>? Kolla att organisationsnummer och publik nyckel stämmer.</li>
                                <li><strong>Timeout-problem?</strong> Se nästa FAQ-punkt.</li>
                            </ul>
                            <p>Kontrollera även pluginets loggfil för mer detaljerad information om eventuella fel.</p>
                            <p>Fortfarande strul? Maila oss på <a href="mailto:support@ideang.se">support@ideang.se</a>!</p>
                        </div>
                    </div>
                    
                    <div class="bokforehandel-faq-item bokforehandel-notice">
                        <h4>Synkronisering avbryts?</h4>
                        <div class="bokforehandel-faq-answer">
                            <p>Synkroniseringen körs på våra servrar, så den belastar inte din wordpressinstallation. Om det ändå blir timneout kan du testa att höja minnesgränsen och tidsgränsen för PHP-processerna.</p>
                            <ol>
                                <li>Lägg till följande kod i din <code>wp-config.php</code>-fil:</li>
                            </ol>
                            <div class="bokforehandel-code-block">
                                <pre>
define('WP_MAX_MEMORY_LIMIT', '256M');
set_time_limit(300);
                                </pre>
                            </div>
                            <p>Observera att synkroniseringen körs i bakgrunden, så även om webbsidan visas som timeout, kan synkroniseringen fortfarande pågå på servern. Kolla alltid i "Synkroniseringar" för att se korrekt status.</p>
                        </div>
                    </div>
                    
                    <div class="bokforehandel-faq-item bokforehandel-notice">
                        <h4>Hur vet jag att det funkar?</h4>
                        <div class="bokforehandel-faq-answer">
                            <p>Kolla i <strong>Synkronisera</strong>:</p>
                            <ol>
                                <li>Se status på körningar.</li>
                                <li>Klicka <strong>Visa detaljer</strong> för mer info.</li>
                                <li><strong>Kontrollera bokföringen i Bjorn Lunden!</strong></li>
                            </ol>
                            <div class="screenshot-container">
                                <img src="<?php echo plugin_dir_url(__FILE__) . '../assets/images/korningar-exempel.jpg'; ?>" alt="Körningar-sidan">
                                <p class="screenshot-caption">Exempel på synkronseringshistorik i pluginet</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="bokforehandel-faq-item bokforehandel-notice">
                        <h4>Hur väljer jag rätt konton?</h4>
                        <div class="bokforehandel-faq-answer">
                            <p>Förifyllda konton fungerar för de flesta, men kolla med din bokförare:</p>
                            <ul>
                                <li>Klarna/Stripe → 1580 (kundfordringar).</li>
                                <li>Direktbetalning → 1930 (bankkonto).</li>
                                <li>Försäljning → 3001 (25% moms). Framtida versioner kommer stödja olika försäljningskonton för olika momssatser.</li>
                                <li>Utgående moms → 2610</li>
                                <li>Avgifter → 6064</li>
                                <li>Ingående moms → 2640</li>
                            </ul>
                            <p>Ändringar av konton gäller bara för nya bokföringar, inte retroaktivt.</p>
                            <div class="bokforehandel-notice notice-warning inline">
                                <p><strong>OBS:</strong> Använd alltid konton som finns i din kontoplan i Bjorn Lunden.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="text-right">
                <a href="#top" class="back-to-top-link">Tillbaka till toppen ↑</a>
            </div>
        </section>
        
        <section id="bokforing" class="help-section">
            <h2>Mer om bokföring</h2>
            
            <div class="bokforehandel-faq bokforehandel-card">
                <div class="bokforehandel-faq-item bokforehandel-notice">
                    <h4>Bokföringsexempel</h4>
                    <div class="bokforehandel-faq-answer">
                        <p>Här ser du hur det kan se ut i Bjorn Lunden när plugin bokför dina transaktioner:</p>
                        
                        <h4>Order: 1250 kr (1000 kr + 250 kr moms)</h4>
                        <table class="bokforehandel-accounting-table">
                            <thead>
                                <tr>
                                    <th>Konto</th>
                                    <th>Beskrivning</th>
                                    <th>Debet</th>
                                    <th>Kredit</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>3001</td>
                                    <td>Försäljning</td>
                                    <td></td>
                                    <td class="kredit">1000 kr</td>
                                </tr>
                                <tr>
                                    <td>2610</td>
                                    <td>Utgående moms</td>
                                    <td></td>
                                    <td class="kredit">250 kr</td>
                                </tr>
                                <tr>
                                    <td>1580</td>
                                    <td>Kundfordringar</td>
                                    <td class="debet">1250 kr</td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>
                        <div class="bokforehandel-notice notice-info inline">
                            <p>Vid direktbetalning (Swish, banköverföring etc.) används konto 1930 (Bankkonto) istället för 1580.</p>
                        </div>
                    </div>
                </div>
                
                <div class="bokforehandel-faq-item bokforehandel-notice">
                    <h4>Klarna-utbetalning: 1225 kr (avgift 25 kr, varav 5 kr moms)</h4>
                    <div class="bokforehandel-faq-answer">
                        <table class="bokforehandel-accounting-table">
                            <thead>
                                <tr>
                                    <th>Konto</th>
                                    <th>Beskrivning</th>
                                    <th>Debet</th>
                                    <th>Kredit</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>1930</td>
                                    <td>Bankkonto</td>
                                    <td class="debet">1225 kr</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>6064</td>
                                    <td>Avgifter</td>
                                    <td class="debet">20 kr</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>2640</td>
                                    <td>Ingående moms</td>
                                    <td class="debet">5 kr</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>1580</td>
                                    <td>Kundfordringar</td>
                                    <td></td>
                                    <td class="kredit">1250 kr</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <div class="bokforehandel-faq-item bokforehandel-notice">
                    <h4>Återbetalning: 500 kr (400 kr + 100 kr moms)</h4>
                    <div class="bokforehandel-faq-answer">
                        <table class="bokforehandel-accounting-table">
                            <thead>
                                <tr>
                                    <th>Konto</th>
                                    <th>Beskrivning</th>
                                    <th>Debet</th>
                                    <th>Kredit</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>3001</td>
                                    <td>Försäljning</td>
                                    <td class="debet">400 kr</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>2610</td>
                                    <td>Utgående moms</td>
                                    <td class="debet">100 kr</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>1580</td>
                                    <td>Kundfordringar</td>
                                    <td></td>
                                    <td class="kredit">500 kr</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <div class="bokforehandel-faq-item bokforehandel-notice">
                    <h4>Hantering av flera momssatser</h4>
                    <div class="bokforehandel-faq-answer">
                        <p><strong>Viktigt:</strong> I nuläget hanterar pluginet endast försäljning med 25% moms inom Sverige.</p>
                        
                        <div class="bokforehandel-notice notice-info inline">
                            <p>Stöd för flera momssatser (12%, 6%, 0%) och internationell försäljning är under utveckling. Intresserad av denna funktion? Kontakta oss på <a href="mailto:support@bokforehandel.se">support@bokforehandel.se</a> så håller vi dig uppdaterad!</p>
                        </div>
                        
                        
                        <div class="bokforehandel-notice notice-warning inline">
                            <p><strong>Viktigt:</strong> Om du har behov av att bokföra ordrar med olika momssatser idag, kontakta oss för att diskutera din specifika situation!</p>
                        </div>
                    </div>
                </div>
                
                <div class="bokforehandel-faq-item bokforehandel-notice">
                    <h4>Bokföringsunderlag</h4>
                    <div class="bokforehandel-faq-answer">
                        <p>För varje bokförd transaktion skapas ett underlag som sparas i Bjorn Lunden. Detta innehåller information om:</p>
                        <ul>
                            <li>Order/utbetalningsnummer</li>
                            <li>Datum och tidpunkt</li>
                            <li>Belopp och momsinformation</li>
                            <li>Kund/referensinformation</li>
                        </ul>
                        <p>Underlagen hjälper dig att spåra varifrån varje bokföring kommer och underlättar vid revision.</p>
                        
                        <div class="screenshot-container">
                            <img src="<?php echo plugin_dir_url(__FILE__) . '../assets/images/bokforingsunderlag.jpg'; ?>" alt="Exempel på bokföringsunderlag">
                            <p class="screenshot-caption">Exempel på bokföringsunderlag i Bjorn Lunden</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="text-right">
                <a href="#top" class="back-to-top-link">Tillbaka till toppen ↑</a>
            </div>
        </section>
        
        <section id="gdpr" class="help-section">
            <h2>GDPR & Dataskydd</h2>
            
            <div class="bokforehandel-faq bokforehandel-card">
                <div class="bokforehandel-faq-item bokforehandel-notice">
                    <h4>Datahantering</h4>
                    <div class="bokforehandel-faq-answer">
                        <p>Bokför Ehandel hanterar följande data:</p>
                        <ul>
                            <li>Organisationsnummer samt de uppgifter som fylls i i pluginets inställningar.</li>
                            <li><strong>Order- och kunduppgifter</strong> från WooCommerce</li>
                            <li><strong>Betalningstransaktioner</strong> från Klarna och Stripe</li>
                            <li><strong>Bokföringsinformation</strong> som överförs till Bjorn Lunden</li>
                        </ul>
                        <p>All data hanteras säkert och lagras inte längre än nödvändigt för att uppfylla tjänsten.</p>
                    </div>
                </div>
                
                <div class="bokforehandel-faq-item bokforehandel-notice">
                    <h4>Data som överförs</h4>
                    <div class="bokforehandel-faq-answer">
                        <p>Vid bokföring överförs följande information till Bjorn Lunden:</p>
                        <ul>
                            <li>Ordernummer och kundreferens</li>
                            <li>Datum för order/utbetalning</li>
                            <li>Belopp, moms och produktinformation</li>
                            <li>Avgiftsinformation från betaltjänster</li>
                        </ul>
                        <p>Fullständig persondata överförs inte, endast referensnummer och summor.</p>
                    </div>
                </div>
                
                <div class="bokforehandel-faq-item bokforehandel-notice">
                    <h4>Datalagring</h4>
                    <div class="bokforehandel-faq-answer">
                        <p>Pluginet lagrar loggfiler och körningsinformation för att säkerställa god funktion. Dessa data raderas automatiskt efter 30 dagar.</p>
                    </div>
                </div>
                
                <div class="bokforehandel-faq-item bokforehandel-notice">
                    <h4>Dataskyddsförordningen (GDPR)</h4>
                    <div class="bokforehandel-faq-answer">
                        <p>Bokför Ehandel är utformat för att uppfylla kraven i GDPR:</p>
                        <ul>
                            <li>Minimering av personuppgifter</li>
                            <li>Säker dataöverföring</li>
                            <li>Automatisk dataradering</li>
                            <li>Transparens i vilka data som behandlas</li>
                        </ul>
                        
                    </div>
                </div>
            </div>
            
            <div class="text-right">
                <a href="#top" class="back-to-top-link">Tillbaka till toppen ↑</a>
            </div>
        </section>
        
        <section id="kontakt" class="help-section bokforehandel-contact-section">
            <h2>Kontakta oss</h2>
            <p>Fastnat någonstans trots att du har följt instruktionerna? Ingen fara – vi finns här för att hjälpa dig! Hör av dig så löser vi det tillsammans:</p>
            
            <div class="bokforehandel-contact-item">
                <div class="bokforehandel-contact-icon">
                    <span class="dashicons dashicons-email"></span>
                </div>
                <div class="bokforehandel-contact-text">
                    <strong>E-post:</strong> <a href="mailto:support@bokforehandel.se">support@bokforehandel.se</a>
                </div>
            </div>
            
            <div class="bokforehandel-contact-item">
                <div class="bokforehandel-contact-icon">
                    <span class="dashicons dashicons-admin-site"></span>
                </div>
                <div class="bokforehandel-contact-text">
                    <strong>Hemsida:</strong> <a href="https://www.bokforehandel.se" target="_blank">www.bokforehandel.se</a>
                </div>
            </div>
            
            <div class="bokforehandel-notice notice-info inline">
                <p><strong>För snabbast hjälp:</strong></p>
                <p>Skicka gärna med:</p>
                <ul>
                    <li>Företagsnamn och organisationsnummer</li>
                    <li>WordPress- och WooCommerce-version</li>
                    <li>Vad som strular och eventuella felmeddelanden</li>
                    <li>När problemet började</li>
                    <li>Skärmdumpar som visar problemet</li>
                </ul>
            </div>
            
            <p>Vi svarar normalt inom 24 timmar på vardagar. Vid hög belastning kan det dröja lite längre.</p>
        </section>
        
        <!-- Flyttar FAQ-blocket hit, efter kontakt men före last-updated -->
        <div class="bokforehandel-faq-item bokforehandel-notice">
            <h4>Återställ Inställningar</h4>
            <div class="bokforehandel-faq-answer">
                 <p>Under denna sektion kan du återställa pluginets inställningar till standardvärden. Denna åtgärd är permanent och kan inte ångras.</p>
                 <div style="text-align: center; margin-top: 15px;">
                     <button type="button" id="help-reset-button" class="button button-secondary" style="font-size:1em; padding:8px 16px; margin-right:20px;">Återställ inställningar</button>
                 </div>
            </div>
        </div>
        
        <div class="last-updated">
            Senast uppdaterad: <?php echo esc_html($last_updated); ?>
        </div>
    </div>
</div>

<!-- Back to top button -->
<a href="#top" class="back-to-top" id="back-to-top" title="Tillbaka till toppen">↑</a>

<script>
jQuery(document).ready(function($) {
    // FAQ-toggle
    $('.bokforehandel-faq-item h4').on('click', function() {
        $(this).parent().toggleClass('active');
    });
    
    // Back to top button
    var backToTopButton = $('#back-to-top');
    
    $(window).scroll(function() {
        if ($(this).scrollTop() > 300) {
            backToTopButton.addClass('visible');
        } else {
            backToTopButton.removeClass('visible');
        }
    });
    
    backToTopButton.on('click', function(e) {
        e.preventDefault();
        $('html, body').animate({
            scrollTop: 0
        }, 500);
        return false;
    });
    
    // Smooth scroll for anchor links
    $('a[href^="#"]').on('click', function(e) {
        e.preventDefault();
        
        var target = this.hash;
        var $target = $(target);
        
        if ($target.length) {
            $('html, body').animate({
                scrollTop: $target.offset().top - 50
            }, 500);
            
            // Open FAQ if clicked on FAQ section
            if (target.includes('faq-')) {
                setTimeout(function() {
                    $target.closest('.bokforehandel-faq-item').addClass('active');
                }, 600);
            }
        }
    });
    
    // Öppna FAQ från URL-hash
    if (window.location.hash) {
        var $target = $(window.location.hash);
        if ($target.length) {
            setTimeout(function() {
                $('html, body').animate({
                    scrollTop: $target.offset().top - 50
                }, 500);
                
                // Open FAQ if hash points to FAQ section
                if (window.location.hash.includes('faq-')) {
                    $target.closest('.bokforehandel-faq-item').addClass('active');
                }
            }, 300);
        }
    }
});
</script>

<style>
.code-example {
    background-color: #f5f7f9;
    border-radius: 5px;
    padding: 5px;
    margin: 15px 0;
    border-left: 4px solid #0073aa;
}
.code-example pre {
    margin: 0;
    padding: 15px;
    overflow-x: auto;
    font-family: monospace;
    color: #333;
}
.bokforehandel-faq-item.active .bokforehandel-faq-answer {
    display: block;
}
.bokforehandel-faq-answer {
    display: none;
}
.bokforehandel-faq-item h4 {
    cursor: pointer;
    font-weight: 600;
    transition: color 0.3s;
}
.bokforehandel-faq-item h4:hover {
    color: #0073aa;
}
.bokforehandel-checklist {
    background: #f9f9f9;
    padding: 15px;
    border-radius: 5px;
    margin-top: 20px;
}
.bokforehandel-checklist ul {
    list-style: none;
    padding-left: 0;
}
.bokforehandel-checklist li {
    margin-bottom: 10px;
}
</style>

<script>
jQuery(document).ready(function($) {
    // Hantera återställningsknappen
    $('#help-reset-button').on('click', function() {
        if (confirm('VARNING! Detta kommer att återställa alla inställningar till standardvärden. Vill du fortsätta?')) {
            $(this).prop('disabled', true).text('Återställer...');
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'bokforehandel_reset_settings',
                    nonce: '<?php echo wp_create_nonce("bokforehandel_nonce"); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        alert('Inställningarna har återställts.');
                        location.reload();
                    } else {
                        alert('Fel vid återställning: ' + (response.data.message || 'Okänt fel'));
                    }
                    $('#help-reset-button').prop('disabled', false).text('Återställ inställningar');
                },
                error: function(xhr, status, error) {
                    alert('AJAX-fel vid återställning: ' + error + ' Status: ' + status);
                    console.log('AJAX Error Details:', xhr.responseText);
                    $('#help-reset-button').prop('disabled', false).text('Återställ inställningar');
                }
            });
        }
    });
});
</script>