<?php
// Förhindra att sidan renderas flera gånger
global $bokforehandel_company_settings_rendered;
if (isset($bokforehandel_company_settings_rendered) && $bokforehandel_company_settings_rendered === true) {
    return;
}
$bokforehandel_company_settings_rendered = true;

// Hämta sparade inställningar
$company_name = get_option('bokforehandel_company_name', get_bloginfo('name'));
$store_name = get_option('bokforehandel_store_name', get_bloginfo('name'));
$organization_number = get_option('bokforehandel_organization_number', '');
$bl_user_key = get_option('bokforehandel_bl_user_key', '');
$sync_enabled = get_option('bokforehandel_sync_enabled', 'yes');

error_log('Laddar företagsinställningar: ' . print_r(compact('company_name', 'store_name', 'organization_number', 'bl_user_key', 'sync_enabled'), true));

$user_id = get_option('bokforehandel_user_id', '');
$wc_api_url = get_option('bokforehandel_wc_api_url', site_url('wp-json/wc/v3'));
$wc_consumer_key = get_option('bokforehandel_wc_consumer_key', '');
$wc_consumer_secret = get_option('bokforehandel_wc_consumer_secret', '');

// Klarna API-inställningar
$klarna_enabled = get_option('bokforehandel_klarna_enabled', false);
$klarna_api_username = get_option('bokforehandel_klarna_api_username', '');
$klarna_api_password = get_option('bokforehandel_klarna_api_password', '');

// Stripe API-inställningar
$stripe_enabled = get_option('bokforehandel_stripe_enabled', false);
$stripe_api_key = get_option('bokforehandel_stripe_api_key', '');

// Dokumentuppladdning
$upload_receipts = get_option('bokforehandel_upload_receipts', true);
$upload_settlements = get_option('bokforehandel_upload_settlements', true);

// Om inga WC API-nycklar är sparade, försök skapa automatiskt om användaren har rättigheter
if (empty($wc_consumer_key) && current_user_can('manage_woocommerce') && class_exists('Bokfor_Ehandel')) {
    global $bokforehandel_instance;
    if (isset($bokforehandel_instance) && method_exists($bokforehandel_instance, 'maybe_create_wc_api_keys')) {
        $bokforehandel_instance->maybe_create_wc_api_keys();
        $wc_consumer_key = get_option('bokforehandel_wc_consumer_key', '');
        $wc_consumer_secret = get_option('bokforehandel_wc_consumer_secret', '');
    }
}
?>
<div class="wrap bokforehandel-admin">
    <h1 class="wp-heading-inline">Bokför Ehandel - Företag & API-inställningar</h1>
    
    <div class="bokforehandel-admin-header">
        <!-- Integration-statusrutan – alltid visas -->
        <div class="bokforehandel-status-box">
            <h2>Bjorn Lunden Integrationsstatus</h2>
            <div class="status-container">
                <?php if (empty($user_id)) : ?>
                    <p><strong>Integration:</strong> <span id="bl-integration-status" style="color: red;">Inaktiv</span></p>
                    <p class="description">Du har inte registrerat dig hos tjänsten. Fyll i uppgifterna nedan och klicka på "Spara inställningar" för att registrera dig.</p>
                <?php else: ?>
                    <p><strong>Integration:</strong> <span id="bl-integration-status">Kontrollerar...</span></p>
                    <div id="bl-activation-help" style="display:none;" class="bokforehandel-welcome-panel">
                        <div class="bl-help-content">
                            <h3>Hur aktiverar jag integrationen?</h3>
                            <ol>
                                <li>Logga in i Bjorn Lunden</li>
                                <li>Gå till "Integrationscenter"</li>
                                <li>Hitta "Bokför Ehandel" i listan</li>
                                <li>Klicka på "Aktivera"</li>
                                <li>Välj ditt företag och bekräfta</li>
                            </ol>
                            <p>När du har aktiverat integrationen i Bjorn Lunden kommer statusen här uppdateras automatiskt inom en minut.</p>
                            <p><strong>Viktigt:</strong> Se till att organisationsnumret i pluginets inställningar exakt matchar det du senare valt i Bjorn Lunden.</p>
                        </div>
                    </div>
                    <!-- Automatisk synkronisering – visas endast när registrerad -->
                    <div class="bokforehandel-notice notice-info" style="display: flex; align-items: center; justify-content: space-between;">
                        <div>
                            <p style="margin: 0;">
                                <strong>Automatisk bokföring:</strong>
                                <span class="status-text" style="margin-left: 5px; font-size: 120%;"><?php echo esc_html(($sync_enabled === 'yes') ? 'Aktiverad' : 'Inaktiverad'); ?></span>
                            </p>
                            <p class="description" style="margin: 5px 0 0 0;">Bokför ordrar och utbetalningar varje natt kl 02:00.</p>
                        </div>
                        <div>
                            <label class="switch" style="margin-left: 15px;">
                                <input type="checkbox" id="auto-sync-top" name="sync_enabled" value="yes" <?php echo ($sync_enabled === 'yes') ? 'checked="checked"' : ''; ?>>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Registreringsnotis, mer framträdande och med stängningsknapp -->
        <?php if (empty($user_id)): ?>
        <div class="bokforehandel-notice notice-warning" style="background-color: #fff3cd; border-left: 4px solid #ffb900; padding:15px; font-size: 16px; margin-top: 20px;">
            <span class="close-notice" style="cursor:pointer; float: right; font-size:20px;">&times;</span>
            <p><strong>Registrering krävs</strong>: Du är inte registrerad hos tjänsten än. Fyll i dina uppgifter nedan och klicka på "Spara inställningar" för att registrera dig och aktivera integrationen.</p>
        </div>
        <script>
            jQuery(document).ready(function($) {
                $('.close-notice').on('click', function(){
                    $(this).parent().fadeOut();
                });
            });
        </script>
        <?php endif; ?>
    </div>
    
    <!-- Tillagd notis som påminnelse – kollapsbar med close-knapp -->
    <div class="bokforehandel-notice notice-info" style="background-color: #e7f3fe; border-left: 4px solid #2196F3; padding: 10px; font-size: 16px; margin: 20px 0; position: relative;">
        <span class="close-notice" style="cursor:pointer; position: absolute; top:5px; right:10px; font-size:20px;">&times;</span>
        OBS! Fyll i alla uppgifter nedan – dessa är nödvändiga för att pluginet ska fungera korrekt.
    </div>
    <script>
        jQuery(document).ready(function($) {
            $('.close-notice').on('click', function(){
                $(this).parent().fadeOut();
            });
        });
    </script>
    
    <!-- Flytta ut "Välkommen till Bokför Ehandel!" ovanför formuläret -->
    <div class="bokforehandel-welcome-box">
        <div id="welcome-toggle" style="cursor: pointer; display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
            <h3 style="margin: 0; display: flex; align-items: center;">
                <span class="dashicons dashicons-info-outline" style="margin-right: 10px; color: #2271b1;"></span>
                Välkommen till Bokför Ehandel!
            </h3>
            <span class="dashicons dashicons-arrow-down-alt2" id="welcome-arrow"></span>
        </div>
        <div id="welcome-content" style="display: none; border-top: 1px solid #dcdcde; padding-top: 15px; margin-top: 10px;">
            <p>Bokför Ehandel är en smart integration som automatiskt överför dina försäljningar från WooCommerce till ditt bokföringssystem hos Bjorn Lunden. Slipp manuell bokföring och låt systemet sköta jobbet – spara tid och undvik fel!</p>
            
            <h4>Vad gör integrationen?</h4>
            <ul style="list-style: disc; margin-left: 20px;">
                <li><strong>Automatisk bokföring av ordrar</strong> – varje försäljning registreras med rätt konton och moms</li>
                <li><strong>Bokför Klarna-utbetalningar</strong> – automatisk avstämning av dina Klarna-transaktioner</li>
                <li><strong>Bokför Stripe-utbetalningar</strong> – håll koll på alla Stripe-betalningar</li>
                <li><strong>Skapar underlag och verifikationer</strong> – genererar professionella PDF-underlag</li>
                <li><strong>Kör automatiskt varje natt</strong> – eller manuellt vid behov</li>
            </ul>
            <h4>Så kommer du igång:</h4>
            <ol style="margin-left: 20px;">
                <li><strong>Aktivera integrationen i Bjorn Lunden</strong> – logga in, gå till "Integrationscenter" och aktivera "Bokför Ehandel".</li>
                <li><strong>Konfigurera pluginet</strong> – fyll i dina företagsuppgifter och klistra in din publika nyckel.</li>
                <li><strong>Klart!</strong> – När allt är ifyllt aktiveras integrationen automatiskt.</li>
            </ol>
            <p>Behöver du hjälp? Kolla in <a href="<?php echo esc_url(admin_url('admin.php?page=bokforehandel-help')); ?>">hjälpsidan</a> för mer information.</p>
        </div>
    </div>
    
    <div class="bokforehandel-admin-content">
        <form id="bokforehandel-company-form" method="post">
            <!-- Bjorn Lunden API-anslutning placerad ovanför företagsinformationen -->
            <div class="form-subsection bokforehandel-card">
                <h3>Bjorn Lunden API-anslutning</h3>
                <p>API-nycklar för anslutning till Bjorn Lunden.</p>
                <table class="form-table">
                    <tr>
                        <th scope="row"><label for="bl-user-key">BL Publik nyckel</label></th>
                        <td>
                            <input type="text" id="bl-user-key" name="bl_user_key" value="<?php echo esc_attr($bl_user_key); ?>" class="regular-text" required>
                            <p class="description">Din publika API-nyckel från Bjorn Lunden. Du hittar den under Integrationer &gt; Kugghjulet &gt; Publik nyckel.</p>
                        </td>
                    </tr>
                </table>
            </div>
            
            <div class="form-section">
                <h2>Företagsinställningar</h2>
                
                <!-- Företagsinformation -->
                <div class="form-subsection bokforehandel-card">
                    <h3>Företagsinformation</h3>
                    <p>Här anger du vilken information Bokför Ehandel ska använda för att identifiera ditt företag och din webbshop hos Bjorn Lunden.</p>
                    
                    <table class="form-table">
                        <tr>
                            <th scope="row"><label for="organization-number">Organisationsnummer</label></th>
                            <td>
                                <input type="text" id="organization-number" name="organization_number" value="<?php echo esc_attr($organization_number); ?>" class="regular-text" required>
                                <p class="description">Ditt företags organisationsnummer (10 siffror med bindestreck, t.ex. 559123-1234). Måste vara samma som i Bjorn Lunden.</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="company-name">Företagsnamn</label></th>
                            <td>
                                <input type="text" id="company-name" name="company_name" value="<?php echo esc_attr($company_name); ?>" class="regular-text" required>
                                <p class="description">Företagets namn.</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="store-name">Butiksnamn</label></th>
                            <td>
                                <input type="text" id="store-name" name="store_name" value="<?php echo esc_attr($store_name); ?>" class="regular-text" required>
                                <p class="description">Namnet på din webbutik. Används i verifikationer och underlag.</p>
                            </td>
                        </tr>
                    </table>
                </div>
                
                <!-- Faktureringsinformation -->
                <div class="form-subsection bokforehandel-card">
                    <h3>Faktureringsinformation</h3>
                    <p>Denna information behövs för att skicka faktura för tjänsten. Genom att aktivera integrationen och fylla i dessa uppgifter bekräftar du att du accepterar att en faktura skickas till angiven e-postadress.</p>
                    <table class="form-table">
                        <tr>
                            <th scope="row"><label for="billing-email">E-post för fakturering</label></th>
                            <td>
                                <input type="email" id="billing-email" name="billing_email" value="<?php echo esc_attr(get_option('bokforehandel_billing_email', '')); ?>" class="regular-text" required>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="billing-reference">Fakturareferens</label></th>
                            <td>
                                <input type="text" id="billing-reference" name="billing_reference" value="<?php echo esc_attr(get_option('bokforehandel_billing_reference', '')); ?>" class="regular-text" required>
                                <p class="description">Referensperson eller referensnummer för fakturan.</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="billing-address">Faktureringsadress</label></th>
                            <td>
                                <textarea id="billing-address" name="billing_address" class="regular-text" rows="3" required><?php echo esc_textarea(get_option('bokforehandel_billing_address', '')); ?></textarea>
                                <p class="description">Fullständig faktureringsadress (om den skiljer sig från företagets standardadress).</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label>Prisalternativ</label></th>
                            <td>
                                <fieldset>
                                    <legend class="screen-reader-text"><span>Betalningsalternativ</span></legend>
                                    <label>
                                        <input type="radio" name="billing_price_option" value="monthly" <?php checked(get_option('bokforehandel_billing_price_option', 'monthly'), 'monthly'); ?> required>
                                        <span>249 kr/månad (faktureras kvartalsvis i förskott, 747 kr/kvartal)</span>
                                    </label><br>
                                    <label>
                                        <input type="radio" name="billing_price_option" value="yearly" <?php checked(get_option('bokforehandel_billing_price_option', 'monthly'), 'yearly'); ?> required>
                                        <span>2 495 kr/år (faktureras årsvis i förskott)</span>
                                    </label>
                                    <p class="description">Alla priser är exklusive moms.</p>
                                </fieldset>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="billing-agree">Bekräftelse</label></th>
                            <td>
                                <label>
                                    <input type="checkbox" id="billing-agree" name="billing_agree" value="1" <?php checked(get_option('bokforehandel_billing_agree', ''), '1'); ?> required>
                                    Jag bekräftar att jag vill använda Bokför Ehandel-tjänsten och godkänner att en faktura skickas enligt ovanstående villkor.
                                </label>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="disclaimer-agree">Användarvillkor</label></th>
                            <td>
                                <label>
                                    <input type="checkbox" id="disclaimer-agree" name="disclaimer_agreed" value="1" <?php checked(get_option('bokforehandel_disclaimer_agreed', ''), '1'); ?> required>
                                    Jag har läst och godkänner användarvillkoren <a href="#" id="toggle-terms" style="display:block; margin-top:10px; margin-bottom:10px; font-size: 0.95em; font-weight: bold;">Läs användarvillkor</a>
                                            <div id="terms-content" style="display:none; max-height: 300px; overflow-y: auto; padding: 10px; border: 1px solid #ddd; background-color: #f9f9f9; margin-bottom: 15px;">
                                                <h4>Villkor för Bokför Ehandel-tjänsten</h4>
                                                <p>Genom att använda Bokför Ehandel-tjänsten godkänner du följande villkor:</p>
                                                <ol>
                                                    <li><strong>Tjänstens omfattning:</strong> Bokför Ehandel synkroniserar dina WooCommerce-ordrar till Bjorn Lunden.</li>
                                                    <li><strong>Datahantering:</strong> Orderdata överförs via en säker anslutning.</li>
                                                    <li><strong>Ditt ansvar:</strong> Du ansvarar för att kontrollera att informationen är korrekt enligt gällande redovisningsregler.</li>
                                                    <li><strong>Underhåll:</strong> Kortare perioder av planerat underhåll kan förekomma.</li>
                                                    <li><strong>Ansvarsbegränsning:</strong> Vi ansvarar inte för indirekta skador vid användning av tjänsten.</li>
                                                    <li><strong>Force majeure:</strong> Oförutsedda händelser påverkar inte vårt ansvar.</li>
                                                </ol>
                                                <p>Genom att använda tjänsten bekräftar du att du godkänner dessa villkor.</p>
                                            </div>
                            </label>
                        </tr>
                    </table>
                </div>
            </div>
            
            <div class="submit form-buttons">
                <input type="hidden" name="action" value="bokforehandel_save_company">
                <input type="hidden" name="nonce" value="<?php echo wp_create_nonce('bokforehandel_nonce'); ?>">
                <button type="button" class="button button-primary button-large" id="save-company-settings" style="margin-right: 20px; font-size: 1.2em; padding: 10px 20px;">Spara inställningar</button>
            </div>
            
            <!-- FÖR ÅTERSTÄLL/AVINSTALLERING har vi flyttat knappen till help.php -->
        </form>
    </div>
</div>

<script type="text/javascript">
jQuery(document).ready(function($) {
    // Definiera ajaxUrl – kolla om objektet bokforehandel finns, annars använd ajaxurl
    var ajaxUrl = (typeof ajaxurl !== 'undefined') ? ajaxurl : '';
    if (typeof bokforehandel !== 'undefined' && typeof bokforehandel.ajax_url !== 'undefined') {
        ajaxUrl = bokforehandel.ajax_url;
    }
    
    // Klickhändelse för "Spara inställningar"-knappen: Återställer spara-funktionaliteten
    $('#save-company-settings').on('click', function() {
        var $button = $(this);
        $button.text('Sparar...').prop('disabled', true);
        var formData = new FormData($('#bokforehandel-company-form')[0]);
        $.ajax({
            url: ajaxUrl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                $button.text('Spara inställningar').prop('disabled', false);
                if (response.success) {
                    alert('Företagsinställningarna har sparats!');
                    console.log('Sparade data:', response);
                } else {
                    alert('Fel vid sparande: ' + (response.data || 'Okänt fel'));
                    console.error('Fel:', response);
                }
            },
            error: function(xhr, status, error) {
                $button.text('Spara inställningar').prop('disabled', false);
                alert('AJAX-fel: ' + error);
                console.error('AJAX-fel:', xhr.responseText);
            }
        });
    });
    
    // Toggle för välkomstrutan
    $('#welcome-toggle').click(function() {
        $('#welcome-content').slideToggle(300, function() {
            if ($('#welcome-content').is(':visible')) {
                $('#welcome-arrow').removeClass('dashicons-arrow-down-alt2').addClass('dashicons-arrow-up-alt2');
            } else {
                $('#welcome-arrow').removeClass('dashicons-arrow-up-alt2').addClass('dashicons-arrow-down-alt2');
            }
        });
    });
    
    // Toggle för Användarvillkor
    $('#toggle-terms').click(function(e) {
        e.preventDefault();
        $('#terms-content').slideToggle(300, function(){
            var linkText = $('#terms-content').is(':visible') ? 'Dölj användarvillkor' : 'Läs användarvillkor';
            $('#toggle-terms').text(linkText);
        });
    });
});
</script> 