<!-- Förhindra att sidan renderas flera gånger -->
<?php
global $bokforehandel_system_settings_rendered;
if (isset($bokforehandel_system_settings_rendered) && $bokforehandel_system_settings_rendered === true) {
    return;
}
$bokforehandel_system_settings_rendered = true;

// Hämta sparade inställningar
$keep_data_on_uninstall = get_option('bokforehandel_keep_data_on_uninstall', false);
$plugin_version = BOKFOREHANDEL_VERSION;
?>

<div class="wrap bokforehandel-admin">
    <h1 class="wp-heading-inline">Bokför Ehandel - Systeminställningar</h1>
    
    <div class="bokforehandel-content">
        
        <!-- Version & Uppdateringar -->
        <div class="bokforehandel-card">
            <h2>Version & Uppdateringar</h2>
            
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label>Aktuell version</label>
                    </th>
                    <td>
                        <strong><?php echo esc_html($plugin_version); ?></strong>
                        <p class="description">
                            Plugin-version som är installerad
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label>Automatiska uppdateringar</label>
                    </th>
                    <td>
                        <p class="description">
                            Pluginet kontrollerar automatiskt efter nya versioner via WordPress uppdateringssystem.
                            Gå till <a href="<?php echo admin_url('plugins.php'); ?>">Plugins</a> för att se om det finns uppdateringar.
                        </p>
                        <button type="button" class="button" id="check-updates-btn">
                            Kontrollera efter uppdateringar nu
                        </button>
                        <span id="update-check-result" style="margin-left: 10px;"></span>
                    </td>
                </tr>
            </table>
        </div>

        <!-- Data & Avinstallation -->
        <div class="bokforehandel-card">
            <h2>Data & Avinstallation</h2>
            
            <form id="system-settings-form">
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="keep_data_on_uninstall">Behåll data vid avinstallation</label>
                        </th>
                        <td>
                            <label>
                                <input type="checkbox" 
                                       id="keep_data_on_uninstall" 
                                       name="keep_data_on_uninstall" 
                                       value="1"
                                       <?php checked($keep_data_on_uninstall, true); ?>>
                                Behåll alla inställningar och data när pluginet raderas
                            </label>
                            <p class="description">
                                <strong>Aktiverad (✓):</strong> När du raderar pluginet bevaras alla inställningar (organisationsnummer, BL-nyckel, konton, etc.) 
                                så att du kan återinstallera pluginet utan att behöva konfigurera allt igen.<br>
                                <strong>Inaktiverad ( ):</strong> När du raderar pluginet raderas alla inställningar och data från databasen.
                            </p>
                        </td>
                    </tr>
                </table>
                
                <p class="submit">
                    <button type="submit" class="button button-primary" id="save-system-settings">
                        Spara systeminställningar
                    </button>
                    <span class="spinner" style="float: none; margin: 0 10px;"></span>
                    <span id="system-settings-message"></span>
                </p>
            </form>
        </div>

        <!-- Systeminformation -->
        <div class="bokforehandel-card">
            <h2>Systeminformation</h2>
            
            <table class="form-table">
                <tr>
                    <th scope="row">WordPress version</th>
                    <td><?php echo get_bloginfo('version'); ?></td>
                </tr>
                <tr>
                    <th scope="row">WooCommerce version</th>
                    <td><?php echo class_exists('WooCommerce') ? WC()->version : 'Inte installerat'; ?></td>
                </tr>
                <tr>
                    <th scope="row">PHP version</th>
                    <td><?php echo phpversion(); ?></td>
                </tr>
                <tr>
                    <th scope="row">Plugin-mapp</th>
                    <td><code><?php echo BOKFOREHANDEL_PLUGIN_DIR; ?></code></td>
                </tr>
                <tr>
                    <th scope="row">API URL</th>
                    <td><code><?php echo BOKFOREHANDEL_API_URL; ?></code></td>
                </tr>
            </table>
        </div>

    </div>
</div>

<style>
.bokforehandel-admin {
    max-width: 1200px;
}

.bokforehandel-content {
    margin-top: 20px;
}

.bokforehandel-card {
    background: #fff;
    border: 1px solid #ccd0d4;
    border-radius: 4px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 1px 1px rgba(0,0,0,0.04);
}

.bokforehandel-card h2 {
    margin-top: 0;
    padding-bottom: 10px;
    border-bottom: 1px solid #eee;
}

.form-table th {
    width: 250px;
}

#system-settings-message.success {
    color: #46b450;
    font-weight: 600;
}

#system-settings-message.error {
    color: #dc3232;
    font-weight: 600;
}

#update-check-result.success {
    color: #46b450;
}

#update-check-result.info {
    color: #0073aa;
}
</style>

<script>
jQuery(document).ready(function($) {
    
    // Spara systeminställningar
    $('#system-settings-form').on('submit', function(e) {
        e.preventDefault();
        
        var $form = $(this);
        var $button = $('#save-system-settings');
        var $spinner = $form.find('.spinner');
        var $message = $('#system-settings-message');
        
        // Visa spinner
        $button.prop('disabled', true);
        $spinner.addClass('is-active');
        $message.removeClass('success error').text('');
        
        // Hämta form-data
        var formData = {
            action: 'bokforehandel_save_system_settings',
            nonce: '<?php echo wp_create_nonce("bokforehandel_nonce"); ?>',
            keep_data_on_uninstall: $('#keep_data_on_uninstall').is(':checked')
        };
        
        // Skicka AJAX
        $.post(ajaxurl, formData, function(response) {
            $spinner.removeClass('is-active');
            $button.prop('disabled', false);
            
            if (response.success) {
                $message.addClass('success').text('✓ Systeminställningar sparade');
            } else {
                $message.addClass('error').text('✗ Kunde inte spara: ' + (response.data.message || 'Okänt fel'));
            }
            
            // Rensa meddelande efter 3 sekunder
            setTimeout(function() {
                $message.removeClass('success error').text('');
            }, 3000);
        });
    });
    
    // Kontrollera uppdateringar
    $('#check-updates-btn').on('click', function() {
        var $button = $(this);
        var $result = $('#update-check-result');
        
        $button.prop('disabled', true).text('Kontrollerar...');
        $result.removeClass('success info').text('');
        
        $.post(ajaxurl, {
            action: 'wp_ajax_update-plugin',
            slug: 'bokfor-ehandel',
            _ajax_nonce: '<?php echo wp_create_nonce("updates"); ?>'
        }, function(response) {
            $button.prop('disabled', false).text('Kontrollera efter uppdateringar nu');
            
            // Ladda om sidan för att WordPress ska uppdatera plugin-listan
            location.href = '<?php echo admin_url("update-core.php"); ?>';
        }).fail(function() {
            $button.prop('disabled', false).text('Kontrollera efter uppdateringar nu');
            $result.addClass('info').text('Gå till Instrumentpanel → Uppdateringar för att se efter nya versioner');
        });
    });
});
</script>
