<?php
/**
 * Exception-klass för Bokför Ehandel
 * 
 * Standardiserad felhantering för pluginet
 * 
 * @package Bokfor_Ehandel
 * @since 1.2.0
 */

// Om denna fil anropas direkt, avbryt.
if (!defined('ABSPATH')) {
    die;
}

/**
 * Bokför Ehandel Exception
 */
class Bokfor_Ehandel_Exception extends Exception {
    
    /**
     * Felkod
     * 
     * @var string
     */
    private $error_code;
    
    /**
     * Ytterligare data
     * 
     * @var array
     */
    private $data;
    
    /**
     * Konstruktor
     * 
     * @param string $message Felmeddelande
     * @param string $error_code Felkod
     * @param int $code HTTP statuskod eller numerisk kod
     * @param array $data Ytterligare data
     * @param Exception|null $previous Tidigare exception
     */
    public function __construct($message = '', $error_code = 'UNKNOWN_ERROR', $code = 0, $data = array(), Exception $previous = null) {
        parent::__construct($message, $code, $previous);
        $this->error_code = $error_code;
        $this->data = $data;
    }
    
    /**
     * Hämta felkod
     * 
     * @return string
     */
    public function get_error_code() {
        return $this->error_code;
    }
    
    /**
     * Hämta data
     * 
     * @return array
     */
    public function get_data() {
        return $this->data;
    }
    
    /**
     * Konvertera till array för JSON-respons
     * 
     * @return array
     */
    public function to_array() {
        return array(
            'success' => false,
            'error_code' => $this->error_code,
            'message' => $this->getMessage(),
            'data' => $this->data
        );
    }
}

/**
 * API Exception
 */
class Bokfor_Ehandel_API_Exception extends Bokfor_Ehandel_Exception {
    
    /**
     * Konstruktor
     * 
     * @param string $message Felmeddelande
     * @param int $status_code HTTP statuskod
     * @param array $data Ytterligare data
     */
    public function __construct($message = '', $status_code = 500, $data = array()) {
        parent::__construct($message, 'API_ERROR', $status_code, $data);
    }
}

/**
 * Validation Exception
 */
class Bokfor_Ehandel_Validation_Exception extends Bokfor_Ehandel_Exception {
    
    /**
     * Konstruktor
     * 
     * @param string $message Felmeddelande
     * @param array $validation_errors Valideringsfel
     */
    public function __construct($message = '', $validation_errors = array()) {
        parent::__construct($message, 'VALIDATION_ERROR', 400, array('validation_errors' => $validation_errors));
    }
}

/**
 * Settings Exception
 */
class Bokfor_Ehandel_Settings_Exception extends Bokfor_Ehandel_Exception {
    
    /**
     * Konstruktor
     * 
     * @param string $message Felmeddelande
     * @param string $setting_key Inställningsnyckel
     */
    public function __construct($message = '', $setting_key = '') {
        parent::__construct($message, 'SETTINGS_ERROR', 0, array('setting_key' => $setting_key));
    }
}

