<?php
/**
 * Bokför Ehandel - Uninstall Script
 * 
 * Detta script körs när pluginet avinstalleras via WordPress admin.
 * Det tar bort alla inställningar och data som är relaterade till pluginet.
 */

// Om uninstall.php inte anropas av WordPress, avbryt.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    die;
}

// Lista över alla alternativ som pluginet har skapat
$option_names = [
    // Företagsinställningar
    'bokforehandel_company_name',
    'bokforehandel_store_name',
    'bokforehandel_organization_number',
    'bokforehandel_bl_user_key',
    'bokforehandel_wc_api_url',
    'bokforehandel_wc_consumer_key',
    'bokforehandel_wc_consumer_secret',
    'bokforehandel_klarna_enabled',
    'bokforehandel_klarna_api_username',
    'bokforehandel_klarna_api_password',
    'bokforehandel_stripe_enabled',
    'bokforehandel_stripe_api_key',
    'bokforehandel_upload_receipts',
    'bokforehandel_upload_settlements',
    
    // Bokföringsinställningar
    'bokforehandel_accounts',
    'bokforehandel_payment_accounts',
    'bokforehandel_payment_settlements',
    
    // Interna alternativ
    'bokforehandel_user_id',
    'bokforehandel_plugin_version',
    'bokforehandel_setup_complete',
    'bokforehandel_last_sync_time',
    'bokforehandel_last_error',
    'bokforehandel_api_status'
];

// Ta bort alla alternativ
foreach ($option_names as $option) {
    delete_option($option);
}

// Ta bort alla transients (tillfälliga data)
delete_transient('bokforehandel_api_status');
delete_transient('bokforehandel_last_sync');
delete_transient('bokforehandel_connection_test');

// Rensa körningsloggar och ordermeta
global $wpdb;

// Ta bort metadatatabell om den existerar
$table_name = $wpdb->prefix . 'bokforehandel_runs';
$wpdb->query("DROP TABLE IF EXISTS $table_name");

// Ta bort order meta
$wpdb->query("DELETE FROM {$wpdb->prefix}postmeta WHERE meta_key LIKE 'bokforehandel_%'");

// Rensa schemalagda händelser
wp_clear_scheduled_hook('bokforehandel_daily_sync');
