<?php
// Förhindra att sidan renderas flera gånger
global $bokforehandel_accounting_settings_rendered;
if (isset($bokforehandel_accounting_settings_rendered) && $bokforehandel_accounting_settings_rendered === true) {
    return;
}
$bokforehandel_accounting_settings_rendered = true;

// Hämta sparade inställningar
$accounts = get_option('bokforehandel_accounts', []);
$payment_accounts = get_option('bokforehandel_payment_accounts', []);
$payment_settlements = get_option('bokforehandel_payment_settlements', []);

// Hämta Klarna och Stripe inställningar
$klarna_enabled = get_option('bokforehandel_klarna_enabled', false);
$klarna_api_username = get_option('bokforehandel_klarna_api_username', '');
$klarna_api_password = get_option('bokforehandel_klarna_api_password', '');
$stripe_enabled = get_option('bokforehandel_stripe_enabled', false);
$stripe_api_key = get_option('bokforehandel_stripe_api_key', '');

// Dokumentuppladdning
$upload_receipts = get_option('bokforehandel_upload_receipts', true);
$upload_settlements = get_option('bokforehandel_upload_settlements', true);

error_log('Laddar bokföringsinställningar: ' . print_r([
    'accounts' => $accounts,
    'payment_accounts' => $payment_accounts,
    'payment_settlements' => $payment_settlements,
    'klarna_enabled' => $klarna_enabled,
    'stripe_enabled' => $stripe_enabled
], true));

// Hämta aktiva betalningsmetoder
if (class_exists('Bokfor_Ehandel')) {
    global $bokforehandel_instance;
    if (isset($bokforehandel_instance) && method_exists($bokforehandel_instance, 'get_active_payment_gateways')) {
        $payment_gateways = $bokforehandel_instance->get_active_payment_gateways();
    } else {
        $payment_gateways = [];
    }
} else {
    $payment_gateways = [];
}
?>
<div class="wrap bokforehandel-admin">
    <h1 class="wp-heading-inline">Bokför Ehandel - Bokföringsinställningar</h1>
    
    <div class="bokforehandel-welcome-panel">
        <h2>Bokföringsinställningar</h2>
        <p>Här konfigurerar du vilka bokföringskonton som ska användas för transaktioner och betalningsmetoder. Kolla med din bokförare eller bokföring så det blir rätt konton och serier.</p>
    </div>
    
    <div class="bokforehandel-admin-content">
        <div class="form-section">
            <h2>Betalningstjänster och Bokföringskonton</h2>
            <p>Om du använder Klarna eller Stripe som betalningsmetoder så kan du aktivera bokföringen för dessa tjänster. Se hjälpsidan för detaljerad information om var du hittar API-nycklar.</p>
            
            <form id="bokforehandel-accounting-form" method="post">
                <!-- Betalningstjänster -->
                <div class="form-subsection bokforehandel-card">
                    <h3>Betalningstjänster</h3>
                    <p>Aktivera Klarna och/eller Stripe för att bokföra utbetalningar från dessa tjänster.</p>
                    
                    <table class="form-table">
                        <tr>
                            <th scope="row"><label for="klarna-enabled"><strong>Bokför Klarna utbetalningar</strong></label></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="klarna-enabled" name="klarna_enabled" value="true" <?php echo ($klarna_enabled) ? 'checked="checked"' : ''; ?>>
                                    <span class="slider round"></span>
                                </label>
                                <p class="description">Aktivera för att bokföra Klarna utbetalningar automatiskt.</p>
                            </td>
                        </tr>
                        
                        <tr class="klarna-settings" <?php if (!$klarna_enabled) echo 'style="display: none;"'; ?>>
                            <th scope="row"><label for="klarna-api-username">Klarna API-användarnamn</label></th>
                            <td>
                                <input type="text" id="klarna-api-username" name="klarna_api_username" value="<?php echo esc_attr($klarna_api_username); ?>" class="regular-text">
                                <p class="description">Användarnamn för Klarna API (hittas i ditt Klarna-konto: Inställningar &gt; Klarna API-nycklar).</p>
                            </td>
                        </tr>
                        
                        <tr class="klarna-settings" <?php if (!$klarna_enabled) echo 'style="display: none;"'; ?>>
                            <th scope="row"><label for="klarna-api-password">Klarna API-lösenord</label></th>
                            <td>
                                <input type="text" id="klarna-api-password" name="klarna_api_password" value="<?php echo esc_attr($klarna_api_password); ?>" class="regular-text">
                                <p class="description">Lösenord för Klarna API (hittas i ditt Klarna-konto: Inställningar &gt; Klarna API-nycklar)).</p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="stripe-enabled"><strong>Bokför Stripe utbetalningar</strong></label></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="stripe-enabled" name="stripe_enabled" value="true" <?php echo ($stripe_enabled) ? 'checked="checked"' : ''; ?>>
                                    <span class="slider round"></span>
                                </label>
                                <p class="description">Aktivera för att bokföra Stripe-utbetalningar automatiskt.</p>
                            </td>
                        </tr>
                        
                        <tr class="stripe-settings" <?php if (!$stripe_enabled) echo 'style="display: none;"'; ?>>
                            <th scope="row"><label for="stripe-api-key">Stripe API-nyckel</label></th>
                            <td>
                                <input type="text" id="stripe-api-key" name="stripe_api_key" value="<?php echo esc_attr($stripe_api_key); ?>" class="regular-text">
                                <p class="description">API-nyckel för Stripe (hittas i ditt Stripe-konto: utvecklare &gt; API-nycklar &gt; Skapa begränsad nyckel).</p>
                            </td>
                        </tr>
                    </table>
                </div>
                
                <!-- Dokumentuppladdning -->
                <div class="form-subsection bokforehandel-card">
                    <h3>Ladda upp underlag</h3>
                    <p>Välj om kvitton och utbetalningsunderlag ska laddas upp till Bjorn Lunden.</p>
                    
                    <table class="form-table">
                        <tr>
                            <th scope="row"><label for="upload-receipts">Generera och ladda upp underlag för ordrar</label></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="upload-receipts" name="upload_receipts" value="true" <?php echo ($upload_receipts) ? 'checked="checked"' : ''; ?>>
                                    <span class="slider round"></span>
                                </label>
                                <p class="description">PDF-kvitto genereras och laddas upp till bokföringsposten på Bjorn Lunden för varje order.</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="upload-settlements">Ladda upp utbetalningsunderlag</label></th>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" id="upload-settlements" name="upload_settlements" value="true" <?php echo ($upload_settlements) ? 'checked="checked"' : ''; ?>>
                                    <span class="slider round"></span>
                                </label>
                                <p class="description">Bifoga avstämningar från Klarna och Stripe som PDF-underlag till utbetalningsverifikationer på Bjorn Lunden.</p>
                            </td>
                        </tr>
                    </table>
                </div>
                
                <!-- Betalningsmetoder -->
                <div class="form-subsection bokforehandel-card">
                    <h3>Konton för betalningsmetoder</h3>
                    <p>Välj vilka bokföringskonton som ska användas för varje betalningsmetod. Pluginet hämtar de betalmetoder som är aktiverade i woocommerce</p>
                    <p>Rekommenderat är 1580 för kundfordringar (merchants, som hanterar betalningen åt dig) och 1930 för direktbetalningar (tex swish). Ändra efter behov så det blir korrekt för dig.</p>
                    <table class="form-table">
                        <?php foreach ($payment_gateways as $gateway_id => $gateway): 
                            $gateway_name = $gateway['title'];
                            $selected_account = $payment_accounts[$gateway_id] ?? '';
                            $custom_account = '';
                            
                            // Check if we have a complex account structure
                            if (is_array($selected_account) && isset($selected_account['type']) && $selected_account['type'] === 'custom') {
                                $custom_account = $selected_account['account'];
                            } 
                            // Check if we have a custom account stored in the old format (direct account number)
                            elseif ($selected_account && !is_numeric($selected_account)) {
                                $custom_account = $selected_account;
                            } else {
                                $custom_account = $selected_account;
                            }
                            
                            // Default account suggestions
                            $default_account = '';
                            if ($gateway_id == 'kco' || $gateway_id == 'klarna' || $gateway_id == 'stripe') {
                                $default_account = '1580';
                            } elseif ($gateway_id == 'swish') {
                                $default_account = '1930';
                            } else {
                                $default_account = '1930';
                            }
                            
                            // Use default if empty
                            if (empty($custom_account)) {
                                $custom_account = $default_account;
                            }
                        ?>
                        <tr>
                            <th scope="row"><label for="payment-account-<?php echo esc_attr($gateway_id); ?>"><?php echo esc_html($gateway_name); ?></label></th>
                            <td>
                                <input 
                                    type="text" 
                                    id="payment-account-<?php echo esc_attr($gateway_id); ?>" 
                                    name="payment_accounts[<?php echo esc_attr($gateway_id); ?>]" 
                                    value="<?php echo esc_attr($custom_account); ?>" 
                                    class="small-text"
                                    maxlength="4"
                                    pattern="[0-9]{4}">
                                
                                <?php
                                $suggestion = '';
                                if ($gateway_id == 'kco' || $gateway_id == 'klarna') {
                                    $suggestion = '1580 (Kundfordringar)';
                                } elseif ($gateway_id == 'stripe') {
                                    $suggestion = '1580 (Kundfordringar)';
                                } elseif ($gateway_id == 'swish') {
                                    $suggestion = '1930 (Bankkonto)';
                                } elseif ($gateway_id == 'other') {
                                    $suggestion = '1930 (Bankkonto)';
                                }
                                
                                if (!empty($suggestion)):
                                ?>
                                <p class="description"><?php printf(__('Standardkonto för %s: %s', 'bokfor-ehandel'), $gateway_name, $suggestion); ?></p>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                
                <!-- Bokföringskonton -->
                <div class="form-subsection bokforehandel-card">
                    <h3>Bokföringskonton</h3>
                    <p>Välj vilka konton som ska användas för olika typer av transaktioner.</p>
                    
                    <table class="form-table">
                        <tr>
                            <th scope="row"><label for="account-sales"><?php _e('Försäljningskonto', 'bokfor-ehandel'); ?></label></th>
                            <td>
                                <input type="text" id="account-sales" name="accounts[sales_account]" value="<?php echo esc_attr($accounts['sales_account'] ?? '3001'); ?>" class="small-text" maxlength="4" pattern="[0-9]{4}">
                                <p class="description"><?php _e('Konto för försäljning av produkter. I nuläget hanteras enbart försäljning inom Sverige med 25% moms. Standardvärde: 3001', 'bokfor-ehandel'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="account-vat"><?php _e('Utgående momskonto', 'bokfor-ehandel'); ?></label></th>
                            <td>
                                <input type="text" id="account-vat" name="accounts[vat_account]" value="<?php echo esc_attr($accounts['vat_account'] ?? '2610'); ?>" class="small-text" maxlength="4" pattern="[0-9]{4}">
                                <p class="description"><?php _e('Konto för utgående moms. I nuläget hanteras enbart försäljning inom Sverige med 25% moms. Standardvärde: 2610', 'bokfor-ehandel'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="account-bank"><?php _e('Bankkonto', 'bokfor-ehandel'); ?></label></th>
                            <td>
                                <input type="text" id="account-bank" name="accounts[bank_account]" value="<?php echo esc_attr($accounts['bank_account'] ?? '1930'); ?>" class="small-text" maxlength="4" pattern="[0-9]{4}">
                                <p class="description"><?php _e('Konto för banktransaktioner. Standardvärde: 1930', 'bokfor-ehandel'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="account-receivables"><?php _e('Kundfordringskonto', 'bokfor-ehandel'); ?></label></th>
                            <td>
                                <input type="text" id="account-receivables" name="accounts[receivables_account]" value="<?php echo esc_attr($accounts['receivables_account'] ?? '1580'); ?>" class="small-text" maxlength="4" pattern="[0-9]{4}">
                                <p class="description"><?php _e('Konto för kundfordringar. Standardvärde: 1580', 'bokfor-ehandel'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="account-fee"><?php _e('Avgiftskonto', 'bokfor-ehandel'); ?></label></th>
                            <td>
                                <input type="text" id="account-fee" name="accounts[fee_account]" value="<?php echo esc_attr($accounts['fee_account'] ?? '6064'); ?>" class="small-text" maxlength="4" pattern="[0-9]{4}">
                                <p class="description"><?php _e('Konto för avgifter från betalningsmetoder. Standardvärde: 6064', 'bokfor-ehandel'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="account-input-vat"><?php _e('Ingående momskonto', 'bokfor-ehandel'); ?></label></th>
                            <td>
                                <input type="text" id="account-input-vat" name="accounts[input_vat_account]" value="<?php echo esc_attr($accounts['input_vat_account'] ?? '2640'); ?>" class="small-text" maxlength="4" pattern="[0-9]{4}">
                                <p class="description"><?php _e('Konto för ingående moms på avgifter. Standardvärde: 2640', 'bokfor-ehandel'); ?></p>
                            </td>
                        </tr>
                    </table>
                </div>

                <!-- Journal ID-inställningar -->
                <div class="form-subsection bokforehandel-card">
                    <h3>Bokföringsserie</h3>
                    <p>Välj vilken bokföringsserie som ska användas. Du kan behöva skapa serien i Bjorn Lunden.</p>
                    
                    <table class="form-table">
                        <tr>
                            <th scope="row"><label for="journal-id"><?php _e('Ordrar', 'bokfor-ehandel'); ?></label></th>
                            <td>
                                <input type="text" id="journal-id" name="accounts[journal_id]" value="<?php echo esc_attr($accounts['journal_id'] ?? 'W'); ?>" class="small-text" maxlength="3">
                                <p class="description"><?php _e('Serie för bokföring av ordrar. Standardvärde: W (som i webshop)', 'bokfor-ehandel'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="klarna-journal-id"><?php _e('Klarna Journal ID', 'bokfor-ehandel'); ?></label></th>
                            <td>
                                <input type="text" id="klarna-journal-id" name="accounts[klarna_journal_id]" value="<?php echo esc_attr($accounts['klarna_journal_id'] ?? 'W'); ?>" class="small-text" maxlength="3">
                                <p class="description"><?php _e('Serie för bokföring av Klarna-utbetalningar. Standardvärde: W (ändra detta om du lättare vill kunna skilja på ordrar och utbetalningar)', 'bokfor-ehandel'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="stripe-journal-id"><?php _e('Stripe Journal ID', 'bokfor-ehandel'); ?></label></th>
                            <td>
                                <input type="text" id="stripe-journal-id" name="accounts[stripe_journal_id]" value="<?php echo esc_attr($accounts['stripe_journal_id'] ?? 'W'); ?>" class="small-text" maxlength="3">
                                <p class="description"><?php _e('Serie för bokföring av Stripe-utbetalningar. Standardvärde: W', 'bokfor-ehandel'); ?></p>
                            </td>
                        </tr>
                    </table>
                </div>
                
                <div class="submit form-buttons">
                    <input type="hidden" name="action" value="bokforehandel_save_accounting">
                    <input type="hidden" name="nonce" value="<?php echo wp_create_nonce('bokforehandel_nonce'); ?>">
                    <button type="button" class="button button-primary button-large" id="save-accounting-settings">Spara inställningar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">
jQuery(document).ready(function($) {
    // Säkerställ tillgång till Ajax URL och nonce
    var ajaxUrl = '';
    var nonce = '';
    
    // Kontrollera om bokforehandel finns
    if (typeof bokforehandel !== 'undefined') {
        ajaxUrl = bokforehandel.ajax_url;
        nonce = bokforehandel.nonce;
    } 
    // Annars kontrollera bokforehandel_params
    else if (typeof bokforehandel_params !== 'undefined') {
        ajaxUrl = bokforehandel_params.ajax_url;
        nonce = bokforehandel_params.nonce;
    }
    // Sista utväg, använd adminajax
    else if (typeof ajaxurl !== 'undefined') {
        ajaxUrl = ajaxurl;
        // Försök hämta nonce från formuläret
        nonce = $('#bokforehandel-accounting-form input[name="nonce"]').val();
    }
    
    console.log('AJAX URL: ' + ajaxUrl);
    console.log('Har nonce: ' + (nonce ? 'Ja' : 'Nej'));
    
    // Hantera sparknappen
    $('#save-accounting-settings').on('click', function() {
        var $button = $(this);
        $button.text('Sparar...').prop('disabled', true);

        var formData = new FormData($('#bokforehandel-accounting-form')[0]);
        
        // Säkerställ att nonce finns med i formData
        // FormData borde inkludera alla fält, men vi kan dubbelkolla.
        if (!formData.has('nonce')) {
            formData.append('nonce', nonce);
        }
         if (!formData.has('action')) {
            formData.append('action', 'bokforehandel_save_accounting');
        }

        console.log('Skickar data:', Object.fromEntries(formData)); // Logga data som skickas

        $.ajax({
            url: ajaxUrl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                $button.text('Spara inställningar').prop('disabled', false);
                if (response.success) {
                    alert('Bokföringsinställningarna har sparats!');
                    console.log('Sparade data:', response);
                } else {
                    // Förbättrad felhantering vid success=false
                    let errorMessage = 'Fel vid sparande: ';
                    if (typeof response.data === 'string') {
                        errorMessage += response.data;
                    } else if (typeof response.data === 'object' && response.data !== null && response.data.message) {
                        errorMessage += response.data.message;
                    } else {
                        errorMessage += 'Okänt fel från servern.';
                    }
                    alert(errorMessage);
                    console.error('Fel från server (success=false):', response);
                }
            },
            error: function(xhr, status, error) {
                $button.text('Spara inställningar').prop('disabled', false);
                // Logga hela xhr-objektet och specifikt responseText för mer detaljer
                console.error('AJAX Request Failed:', xhr);
                console.error('Status:', status);
                console.error('Error:', error);
                console.error('Server Response Text:', xhr.responseText); // Logga serverns svar
                alert('AJAX-fel: ' + error + '. Kontrollera webbläsarens konsol för mer information.');
            }
        });
    });
    
    // Visa/dölj Klarna-inställningar
    $('#klarna-enabled').change(function() {
        $('.klarna-settings').toggle(this.checked);
    });
    
    // Visa/dölj Stripe-inställningar
    $('#stripe-enabled').change(function() {
        $('.stripe-settings').toggle(this.checked);
    });
});
</script> 